/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import java.util.List;
import java.util.Random;
import net.tejpbit.ais.AI_Challenger;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.plugin.AI_Complexer;

public class MineprobChallenge
extends MinesweeperPlugin
implements EventListener {
    private double thinkProbability;
    private MineprobabilityAnalyze analyze;

    @Event
    public void getMineProbabilityOfMove(PlayerMoveEvent event) {
        if (event.getPlayer().getGame() == null) {
            return;
        }
        double chosen = MineprobHelper.getMineProbabilityForField(event.getMove().getMovePosition());
        if (Math.abs(chosen - this.thinkProbability) <= 1.0E-4) {
            event.getGame().sendChatMessage("MineprobChallenge: Well done!");
            this.onChallengeStart(new GameStartEvent(event.getGame()));
            for (MinesweeperField field : event.getGame().getIteration()) {
                field.sendInfoToPlayers();
            }
        } else {
            this.gameSend(event.getGame(), "Sorry. I asked you to find a field with probability of\n" + this.thinkProbability + "\nbut you found one with\n" + chosen);
            event.getMove().getMovePosition().sendInfoToPlayers();
        }
        event.setCancelled(true);
    }

    @Event
    public void onChallengeStart(GameStartEvent event) {
        this.createSomethingRandom(event.getGame());
        this.analyze = new MineprobabilityAnalyze((MinesweeperMap)event.getGame());
        AnalyzeResult solve = this.analyze.solve();
        FieldGroup random = (FieldGroup)UtilZomisList.getRandom((List)solve.getGroups());
        this.thinkProbability = random.getProbability();
        this.gameSend(event.getGame(), "MineprobChallenge: I want you to click on a field with Mineprobability " + this.thinkProbability);
        event.getGame().sendChatMessage("MineprobChallenge: I want you to click on a field with Mineprobability " + this.thinkProbability);
    }

    private void gameSend(MinesweeperGame game, String string) {
        for (MinesweeperPlayer player : game.getPlayers()) {
            player.sendAlert(string);
        }
    }

    private void createSomethingRandom(MinesweeperGame game) {
        Random random = new Random();
        for (MinesweeperPlayingPlayer pp : game.getPlayingPlayers()) {
            pp.changeScore(-pp.getScore());
        }
        game.generate();
        int amount = random.nextInt(42) + 10;
        game.sendChatMessage("Making " + amount + " moves.");
        for (int i = 0; i < amount; ++i) {
            if (game.getCurrentPlayer().getScore() >= 20) {
                game.sendChatMessage("Moves cancelled after " + i + " because of player score: " + game.getCurrentPlayer());
                break;
            }
            MinesweeperMove move = i <= amount - 10 ? game.getMapFactory().ai(game.getCurrentPlayer(), AI_Challenger.class).play() : game.getMapFactory().ai(game.getCurrentPlayer(), AI_Complexer.class).play();
            if (move != null && move.getWeapon() != null) {
                move.getWeapon().useAt(move);
                continue;
            }
            game.sendChatMessage("Move could not be made: " + move);
        }
        game.setCurrentPlayerTurn(0);
    }

    public boolean canBeChosenBy(MinesweeperPlayer player) {
        return player.hasPermission("ADMIN");
    }

    public void onDisable() {
    }

    public void onEnable() {
        if (this.getServer() == null) {
            throw new NullPointerException("Server missing");
        }
        this.registerListener(this);
        this.registerListener((EventListener)new StandardNeighbors());
        this.registerListener((EventListener)new StandardWeapons());
    }
}

