/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.zomis.minesweeper.analyze.AnalyzeFactory;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;

public class MineprobabilityAnalyze
extends AnalyzeFactory<MinesweeperField> {
    private final MinesweeperMap game;
    private final List<MinesweeperField> knownNonMines = new ArrayList<MinesweeperField>();

    public MineprobabilityAnalyze(MinesweeperMap game) {
        this.game = game;
        this.createRules();
    }

    private final void createRules() {
        this.addRule((RuleConstraint)new FieldRule(null, (Collection)this.game.getAllUnclickedFields(), this.game.getMinesLeft()));
        for (MinesweeperField field : this.game.getIteration()) {
            FieldRule<MinesweeperField> newRule;
            if (!field.isClicked() || field.isMine() || field.isBlocked() || (newRule = this.internalRuleFromField(field, true)) == null || newRule.isEmpty()) continue;
            this.addRule((RuleConstraint)newRule);
        }
        if (!this.knownNonMines.isEmpty()) {
            this.addRule((RuleConstraint)new FieldRule(null, this.knownNonMines, 0));
        }
    }

    private FieldRule<MinesweeperField> internalRuleFromField(MinesweeperField field, boolean addNonMines) {
        ArrayList<MinesweeperField> ruleParams = new ArrayList<MinesweeperField>();
        int foundNeighbors = 0;
        for (MinesweeperField neighbor : field.getNeighbors()) {
            if (neighbor.isDiscoveredMine()) {
                ++foundNeighbors;
                continue;
            }
            if (neighbor.isClicked()) continue;
            ruleParams.add(neighbor);
        }
        if (field.getValue() - foundNeighbors == 0) {
            if (addNonMines) {
                for (MinesweeperField mf : ruleParams) {
                    if (this.knownNonMines.contains(mf)) continue;
                    this.knownNonMines.add(mf);
                }
            }
            return null;
        }
        return new FieldRule((Object)field, ruleParams, field.getValue() - foundNeighbors);
    }

    public FieldRule<MinesweeperField> ruleFromField(MinesweeperField field) {
        return this.internalRuleFromField(field, false);
    }

    public static FieldRule<MinesweeperField> ruleForField(MinesweeperField field, boolean isMine) {
        ArrayList<MinesweeperField> ruleParams = new ArrayList<MinesweeperField>();
        ruleParams.add(field);
        return new FieldRule((Object)field, ruleParams, isMine ? 1 : 0);
    }

    public static FieldRule<MinesweeperField> ruleFromField(MinesweeperField field, int result) {
        ArrayList<MinesweeperField> ruleParams = new ArrayList<MinesweeperField>();
        for (MinesweeperField neighbor : field.getNeighbors()) {
            if (neighbor.isClicked()) continue;
            ruleParams.add(neighbor);
        }
        return new FieldRule((Object)field, ruleParams, result);
    }
}

