/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.endgame;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.endgame.PlayerUtils;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class WinChanceTools {
    public static final int NEEDED_SCORE = 26;

    public static WinResult checkDirectEnding(MinesweeperPlayingPlayer player, AnalyzeResult<MinesweeperField> analyze) {
        double bombWin;
        int certain = MineprobHelper.find100(analyze);
        MinesweeperPlayingPlayer opponent = PlayerUtils.getNextPlayer(player);
        if (MineprobHelper.isDraw(player.getMap())) {
            return WinResult.DRAW;
        }
        MinesweeperField bestBomb = BombTools.getBestBomb(player.getMap(), analyze);
        UtilZomisUtils.echo((Object)("check ending for " + player + " curr " + player.getMap().getPlayerTurn() + " opp " + opponent + " map " + player.getMap().saveMap()));
        if (player.isMyTurn()) {
            if (player.getScore() + certain >= 26) {
                return WinResult.WIN;
            }
            if (player.canUseWeapon("B") && (bombWin = BombTools.getBombWinPercent(analyze, bestBomb, player.getScore())) >= 0.999999) {
                return WinResult.WIN;
            }
        }
        if (opponent.isMyTurn()) {
            if (opponent.getScore() + certain >= 26) {
                return WinResult.LOSS;
            }
            if (opponent.canUseWeapon("B") && (bombWin = BombTools.getBombWinPercent(analyze, bestBomb, opponent.getScore())) >= 0.999999) {
                return WinResult.LOSS;
            }
        }
        return null;
    }

    public static enum WinResult {
        WIN,
        LOSS,
        DRAW;

    }
}

