/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore;

import java.util.Map;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.OpenFieldApproxer;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class AvoidReveal50
extends AbstractScorer {
    OpenFieldApproxer openFieldScan = new OpenFieldApproxer();

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        if (AvoidReveal50.hasProbability(data.getMineProbability(), 1.0)) {
            return 0.0;
        }
        if (ZomisTools.isAIChallengerField(data)) {
            return 0.0;
        }
        Boolean groupFound = null;
        for (Map.Entry ee : data.getNeighbors().entrySet()) {
            if ((Integer)ee.getValue() != 1 || ((FieldGroup)ee.getKey()).size() > 3 || !AvoidReveal50.hasProbability(((FieldGroup)ee.getKey()).getProbability(), 1.0 * (double)(((FieldGroup)ee.getKey()).size() - 1) / (double)((FieldGroup)ee.getKey()).size())) continue;
            if (data.getFieldGroup().size() == 2 && AvoidReveal50.hasProbability(data.getMineProbability(), 0.5)) {
                if (ee.getKey() == data.getFieldGroup()) {
                    return 0.0;
                }
                groupFound = true;
            }
            if (groupFound != null) continue;
            groupFound = false;
        }
        if (groupFound == null) {
            return 0.0;
        }
        return groupFound != false ? -5 : -10;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsClick(scores.getWeapon());
    }
}

