/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Enums;
import net.zomis.mario.classes.Square;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.PreScorer;

public class MarioAnalyze
implements PreScorer {
    private Bot mario = null;

    @Override
    public MarioAnalyze analyze(MinesweeperPlayingPlayer player) {
        this.initMario(player);
        if (!this.mario.getBoard().solved) {
            return null;
        }
        return this;
    }

    private void initMario(MinesweeperPlayingPlayer player) {
        if (this.mario == null) {
            this.mario = new Bot(Enums.PlayerColor.colorFor(player), Enums.Difficult.VERY_HARD_NO_SIMULATE);
        }
        this.mario.move(NightmareTools.fixBoard(player, this.mario));
    }

    public Square getSquare(MinesweeperField field) {
        return this.mario.getBoard().square[field.getY()][field.getX()];
    }

    @Override
    public void scoringComplete() {
        this.mario.javaGarbage();
    }

    public Bot getBot() {
        return this.mario;
    }
}

