/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.classes;

import java.util.ArrayList;
import net.zomis.mario.classes.Frequency;
import net.zomis.mario.classes.KnownPoint;
import net.zomis.mario.classes.MinesweeperFlags;
import net.zomis.mario.classes.UnknownPoint;

public class Group {
    public ArrayList<UnknownPoint> unknown = new ArrayList(15);
    public ArrayList<KnownPoint> known = new ArrayList(10);
    public ArrayList<MinesweeperFlags.ZonePoint> zone;
    public ArrayList<boolean[]> answers = new ArrayList(10);
    public ArrayList<Integer> answersCount = new ArrayList(10);
    private Frequency[] frequency;
    public int[][] correlation;
    public int maximumMines;

    public Group() {
        this.zone = new ArrayList(20);
    }

    public Frequency[] Frequency() {
        if (this.frequency == null) {
            int i;
            this.frequency = new Frequency[this.maximumMines + 1];
            for (i = 0; i < this.frequency.length; ++i) {
                this.frequency[i] = new Frequency();
            }
            for (i = 0; i < this.answers.size(); ++i) {
                ++this.frequency[this.answersCount.get((int)i).intValue()].times;
            }
        }
        return this.frequency;
    }

    public void CalculateCorrelation() {
        this.correlation = new int[this.unknown.size()][this.unknown.size()];
        for (boolean[] answer : this.answers) {
            for (int i = 0; i < answer.length; ++i) {
                if (!answer[i]) continue;
                int[] nArray = this.correlation[i];
                int n = i;
                nArray[n] = nArray[n] + 1;
                for (int j = i + 1; j < answer.length; ++j) {
                    if (!answer[j]) continue;
                    int[] nArray2 = this.correlation[i];
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] + 1;
                    int[] nArray3 = this.correlation[j];
                    int n3 = i;
                    nArray3[n3] = nArray3[n3] + 1;
                }
            }
        }
    }

    public String toString() {
        int j;
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\tKnown Points\r\n\t\t");
        for (i = 0; i < this.known.size(); ++i) {
            stringBuilder.append(this.known.get(i).toString());
            if (i == this.known.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("\n");
        stringBuilder.append("\tUnknown Points\r\n");
        for (i = 0; i < this.unknown.size(); ++i) {
            stringBuilder.append("\t\t" + i + ": " + this.unknown.get(i).toString());
        }
        stringBuilder.append("\tZone\n");
        for (i = 0; i < this.zone.size(); ++i) {
            stringBuilder.append("\t\t" + i + ": " + this.zone.get(i).toString());
        }
        stringBuilder.append("\tAnswers\n");
        if (this.answers.size() == 0) {
            stringBuilder.append("\t\tNone");
        } else if (this.answers.size() > 100) {
            stringBuilder.append("\t\t" + this.answers.size() + " answers");
        } else {
            for (j = 0; j < this.answers.size(); ++j) {
                stringBuilder.append("\t\t[" + j + "]\t");
                boolean[] answer = this.answers.get(j);
                for (int k = 0; k < this.unknown.size(); ++k) {
                    if (answer[k]) {
                        stringBuilder.append("x");
                        continue;
                    }
                    stringBuilder.append(".");
                }
                stringBuilder.append("\t" + this.answersCount.get(j) + "\r\n");
            }
        }
        stringBuilder.append("\tFrequency\n");
        if (this.frequency == null) {
            stringBuilder.append("\t\tNone\n");
        } else {
            for (i = 0; i < this.frequency.length; ++i) {
                stringBuilder.append("\t\t[" + i + "] " + this.frequency[i].toString() + "\r\n");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("\tCorrelation\n");
        if (this.correlation == null) {
            stringBuilder.append("\t\tNone\n");
        } else {
            for (i = 0; i < this.correlation.length; ++i) {
                stringBuilder.append("\t\t");
                for (j = 0; j < this.correlation[0].length; ++j) {
                    stringBuilder.append(this.correlation[i][j] + "\t");
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public void javaGarbage() {
        this.unknown.clear();
    }
}

