/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.utils;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;

public class ZomisTools {
    public static boolean isAIChallengerField(ProbabilityKnowledge<MinesweeperField> fieldData) {
        return !ZomisTools.isZomisOpenField((MinesweeperField)fieldData.getField()) && fieldData.getMineProbability() > 0.0;
    }

    public static int fieldFoundMines(MinesweeperField field) {
        int i = 0;
        for (MinesweeperField ff : field.getNeighbors()) {
            if (!ff.isDiscoveredMine()) continue;
            ++i;
        }
        return i;
    }

    public static int fieldNeedsMoreMines(MinesweeperField field) {
        if (!field.isClicked()) {
            return 0;
        }
        if (field.isDiscoveredMine()) {
            return 0;
        }
        return field.getKnownValue() - ZomisTools.fieldFoundMines(field);
    }

    public static boolean isZomisOpenField(MinesweeperField field) {
        for (MinesweeperField ff : field.getNeighbors()) {
            if (!ff.isClicked() || ff.isDiscoveredMine()) continue;
            return false;
        }
        return true;
    }
}

