/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.impl.EVInfo;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;

public class EVCalculator {
    private final AnalyzeProvider analyze;

    public EVCalculator(AnalyzeProvider analyze) {
        this.analyze = analyze;
    }

    public EVInfo calcEV(ProbabilityKnowledge<MinesweeperField> data) {
        double[] payoffs = this.calcPayoffs(data);
        double minePayoff = this.calcMinePayoff((MinesweeperField)data.getField());
        return new EVInfo(data, minePayoff, payoffs);
    }

    private double calcMinePayoff(MinesweeperField field) {
        return this.getRevealedBy(Arrays.asList(MineprobabilityAnalyze.ruleForField(field, true)));
    }

    private double getRevealedBy(List<FieldRule<MinesweeperField>> ruleList) {
        ArrayList<FieldRule<MinesweeperField>> constraints = new ArrayList<FieldRule<MinesweeperField>>(ruleList);
        AnalyzeResult revealAnalyze = this.analyze.getAnalyze().cloneAddSolve(constraints);
        return MineprobHelper.find100(revealAnalyze);
    }

    private double[] calcPayoffs(ProbabilityKnowledge<MinesweeperField> data) {
        double[] result = new double[data.getProbabilities().length];
        int found = MineprobHelper.getFound((MinesweeperField)data.getField());
        for (int i = 0; i < result.length; ++i) {
            if (data.getProbabilities()[i] <= 0.0) continue;
            result[i] = this.getRevealedBy(Arrays.asList(MineprobabilityAnalyze.ruleForField((MinesweeperField)data.getField(), false), MineprobabilityAnalyze.ruleFromField((MinesweeperField)data.getField(), i - found)));
        }
        return result;
    }

    public Map<MinesweeperField, Double> calculateEV() {
        HashMap<MinesweeperField, Double> map = new HashMap<MinesweeperField, Double>();
        for (ProbabilityKnowledge<MinesweeperField> data : this.analyze.getAllKnowledge()) {
            map.put((MinesweeperField)data.getField(), this.calcEV(data).getEv());
        }
        return map;
    }
}

