/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore.mario;

import net.zomis.mario.classes.Square;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.aiscore.mario.MarioTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RealMarioEV1
extends AbstractScorer {
    private MarioAnalyze mario;

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        Square square = this.mario.getSquare(field);
        if (MarioTools.isMarioOpenField(square)) {
            return 0.0;
        }
        if (data.getMineProbability() == 0.0) {
            boolean onlyOpenFieldNeighbors = true;
            for (MinesweeperField neighbor : field.getNeighbors()) {
                if (MarioTools.isMarioOpenField(this.mario.getSquare(neighbor))) continue;
                onlyOpenFieldNeighbors = false;
                break;
            }
            if (onlyOpenFieldNeighbors) {
                return 0.0;
            }
        }
        if (square.probability[0] > 0.0 && data.getProbabilities()[0] == 0.0) {
            return 0.0;
        }
        if (square.firstExpectedValue == null) {
            return 0.0;
        }
        return square.firstExpectedValue;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        this.mario = scores.getAnalyze(MarioAnalyze.class);
        return this.weaponIsClick(scores.getWeapon());
    }
}

