/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.probability;

import net.zomis.mario.probability.Combinatory;

public class CombinationGenerator {
    int n;
    int k;
    double numLeft;
    double total;
    int[] combination;

    public double getTotal() {
        return this.total;
    }

    public double getLeft() {
        return this.numLeft;
    }

    public CombinationGenerator(int n, int k) {
        this.n = n;
        this.k = k;
        this.combination = new int[n];
        for (int i = 0; i < n; ++i) {
            this.combination[i] = i;
        }
        this.numLeft = this.total = Combinatory.BinomialCoefficient(n, k);
    }

    public boolean HasMore() {
        return this.numLeft != 0.0;
    }

    public int[] GetNext() {
        if (this.numLeft == this.total) {
            this.numLeft -= 1.0;
            return this.combination;
        }
        int i = this.n - 1;
        while (this.combination[i] == this.k - this.n + i) {
            --i;
        }
        this.combination[i] = this.combination[i] + 1;
        for (int j = i + 1; j < this.n; ++j) {
            this.combination[j] = this.combination[i] + j - i;
        }
        this.numLeft -= 1.0;
        return this.combination;
    }
}

