/*
 * Decompiled with CFR 0.152.
 */
package net.tejpbit.ais;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.AI;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

@AI(rating=1500.0)
public class TejpbitAI_Hard
extends MinesweeperAI {
    public TejpbitAI_Hard(MinesweeperPlayingPlayer player) {
        super(player);
    }

    public boolean agreeDraw() {
        return MineprobHelper.isDraw(this.getMap());
    }

    public MinesweeperMove play() {
        MinesweeperField bombField;
        AnalyzeResult<MinesweeperField> gameAnalyze = AnalyzeFactory.analyze(this.getMap(), false).getAnalyze();
        if (this.getPlayingPlayer().canUseWeapon("B") && (bombField = this.eredags(gameAnalyze)) != null) {
            return this.getPlayingPlayer().createMove("B", bombField);
        }
        List groups = gameAnalyze.getGroups();
        ArrayList<Object> highProbabilityFields = new ArrayList();
        double highestProbability = -1.0;
        for (Object group : groups) {
            if (group.getProbability() > highestProbability) {
                highestProbability = group.getProbability();
                highProbabilityFields.clear();
                highProbabilityFields.addAll((Collection<Object>)group);
                continue;
            }
            if (group.getProbability() != highestProbability) continue;
            highProbabilityFields.addAll((Collection<Object>)group);
        }
        if (highProbabilityFields.size() > 8) {
            ArrayList highProbabilityCleaner = new ArrayList(highProbabilityFields);
            for (Object checkAdjacents : highProbabilityFields) {
                boolean hasMineAdjacent = false;
                for (MinesweeperField invertedAdjacents : checkAdjacents.getInvertedNeighbors()) {
                    if (!invertedAdjacents.isMine() || !invertedAdjacents.isClicked()) continue;
                    hasMineAdjacent = true;
                }
                if (hasMineAdjacent) continue;
                highProbabilityCleaner.remove(checkAdjacents);
            }
            if (highProbabilityCleaner.size() > 0) {
                highProbabilityFields = highProbabilityCleaner;
            }
            ArrayList<MinesweeperField> highProbabilityFieldsClone = new ArrayList<MinesweeperField>(highProbabilityFields);
            this.cleanOpenFields(highProbabilityFieldsClone);
            if (highProbabilityFieldsClone.isEmpty()) {
                for (MinesweeperField field : this.getMap().getIteration()) {
                    if (!this.hasAdjacentClickedMine(field) || field.isClicked()) continue;
                    highProbabilityFieldsClone.add(field);
                }
                ArrayList<MinesweeperField> safeDive = new ArrayList<MinesweeperField>();
                for (MinesweeperField field : highProbabilityFieldsClone) {
                    if (!(gameAnalyze.getGroupFor((Object)field).getProbability() > 0.0)) continue;
                    safeDive.add(field);
                }
                if (safeDive.isEmpty() && !highProbabilityFieldsClone.isEmpty()) {
                    highProbabilityFields = highProbabilityFieldsClone;
                }
            }
        }
        Random random = new Random();
        int clickIndex = random.nextInt(highProbabilityFields.size());
        return this.getPlayingPlayer().createMove("P", (MinesweeperField)highProbabilityFields.get(clickIndex));
    }

    private boolean hasAdjacentClickedMine(MinesweeperField field) {
        for (MinesweeperField adjacent : field.getNeighbors()) {
            if (!adjacent.isDiscoveredMine()) continue;
            return true;
        }
        return false;
    }

    private MinesweeperField eredags(AnalyzeResult<MinesweeperField> gameAnalyze) {
        ArrayList bombPossibilitys = new ArrayList();
        HashMap<MinesweeperField, List<MinesweeperField>> bombFields = new HashMap<MinesweeperField, List<MinesweeperField>>();
        for (MinesweeperField bombCheck : this.getMap().getIteration()) {
            ArrayList<MinesweeperField> bombField = new ArrayList<MinesweeperField>(TejpbitAI_Hard.getBombAdjacents(bombCheck));
            if (bombField.size() <= 0) continue;
            bombFields.put(bombCheck, TejpbitAI_Hard.getBombAdjacents(bombCheck));
        }
        double mineProbability = 0.0;
        for (Map.Entry bombField : bombFields.entrySet()) {
            double tempMineProbability = this.getPlayingPlayer().getScore();
            for (MinesweeperField field : (List)bombField.getValue()) {
                if (gameAnalyze.getGroupFor((Object)field) == null) continue;
                tempMineProbability += gameAnalyze.getGroupFor((Object)field).getProbability();
            }
            if (tempMineProbability == mineProbability) {
                bombPossibilitys.add(bombField.getKey());
                continue;
            }
            if (!(tempMineProbability > mineProbability)) continue;
            bombPossibilitys.clear();
            bombPossibilitys.add(bombField.getKey());
            mineProbability = tempMineProbability;
        }
        if (mineProbability >= (double)this.getMap().getMinesCount() / (double)this.getMap().getPlayingPlayers().size()) {
            return (MinesweeperField)UtilZomisList.getRandom(bombPossibilitys);
        }
        return null;
    }

    public static List<MinesweeperField> getBombAdjacents(MinesweeperField field) {
        ArrayList<MinesweeperField> bombAdjacents = new ArrayList<MinesweeperField>();
        int x = field.getX();
        int y = field.getY();
        for (int yy = -2; yy <= 2; ++yy) {
            for (int xx = -2; xx <= 2; ++xx) {
                if (x + xx < 0 || x + xx >= field.getMap().getFieldWidth() || y + yy < 0 || y + yy >= field.getMap().getFieldHeight()) continue;
                bombAdjacents.add(field.getRelativePosition(xx, yy));
            }
        }
        return bombAdjacents;
    }

    private void cleanOpenFields(List<MinesweeperField> fields) {
        for (MinesweeperField field : new ArrayList<MinesweeperField>(fields)) {
            Collection adjacents = field.getNeighbors();
            boolean hasMine = false;
            for (MinesweeperField adjacent : adjacents) {
                if (!adjacent.isDiscoveredMine()) continue;
                hasMine = true;
                break;
            }
            if (hasMine) continue;
            fields.remove(field);
        }
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }
}

