/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.utils;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class MineprobHelper {
    private static final double PROB_100 = 0.999999;

    public static double nanoToMilli(long nano) {
        return (double)nano / 1000000.0;
    }

    public static MinesweeperPlayingPlayer[] getOpponents(MinesweeperPlayingPlayer player) {
        List players = player.getMap().getPlayingPlayers();
        players.remove(player);
        return players.toArray(new MinesweeperPlayingPlayer[players.size()]);
    }

    public static Integer getCertainValue(ProbabilityKnowledge<MinesweeperField> data) {
        double[] probs = data.getProbabilities();
        for (int i = 0; i < probs.length; ++i) {
            if (probs[i] != 1.0) continue;
            return i;
        }
        return null;
    }

    public static double getMineProbabilityForField(MinesweeperField field) {
        MineprobabilityAnalyze analyze = new MineprobabilityAnalyze(field.getMap());
        AnalyzeResult solve = analyze.solve();
        FieldGroup group = solve.getGroupFor((Object)field);
        if (group != null) {
            return group.getProbability();
        }
        return -1.0;
    }

    public static <E> int find100(AnalyzeResult<E> analyze) {
        int i = 0;
        for (FieldGroup grp : analyze.getGroups()) {
            if (!(grp.getProbability() > 0.999999)) continue;
            i += grp.size();
        }
        return i;
    }

    public static List<MinesweeperField> regenerate(MinesweeperMap map, AnalyzeResult<MinesweeperField> analyze, Random random) {
        List randomSolution = analyze.randomSolution(random);
        MineprobHelper.fixRemainingMines(map, randomSolution);
        return randomSolution;
    }

    public static int getFound(MinesweeperField field) {
        int i = 0;
        for (MinesweeperField ff : field.getNeighbors()) {
            if (!ff.isDiscoveredMine()) continue;
            ++i;
        }
        return i;
    }

    public static boolean isDraw(MinesweeperMap map) {
        if (map.getMinesLeft() != 1) {
            return false;
        }
        AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);
        List sols = analyze.getAnalyze().getSolutions();
        if (sols.size() != 1) {
            return false;
        }
        Solution sol = (Solution)sols.iterator().next();
        for (Map.Entry ee : sol.getSetGroupValues().entrySet()) {
            if ((Integer)ee.getValue() == 0 || ((FieldGroup)ee.getKey()).size() == 2 && (Integer)ee.getValue() == 1) continue;
            return false;
        }
        return true;
    }

    public static void fixRemainingMines(MinesweeperMap map, List<MinesweeperField> remaining) {
        for (MinesweeperField ff : map.getIteration()) {
            if (ff.isClicked()) continue;
            ff.setMine(false);
        }
        for (MinesweeperField ff : remaining) {
            if (ff.getMap() != map) {
                ff = map.getPosition(ff);
            }
            ff.setMine(true);
        }
        map.initFields();
    }
}

