/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore;

import java.util.Collection;
import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BombScore
extends AbstractScorer {
    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        MinesweeperPlayingPlayer player = scores.getPlayer();
        Collection affected = scores.getWeapon().getFieldsAffected(player, field);
        if (affected.isEmpty()) {
            return -10000.0;
        }
        double dd = BombTools.getBombProbability(affected, scores.getAnalyze().getAnalyze());
        return (double)((double)player.getScore() + dd >= (double)field.getMap().getMinesCount() / 2.0 ? 100000 : -100) + dd;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsBomb(scores.getWeapon());
    }
}

