/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.test;

import java.util.Map;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.ScoreParameters;

public class AINormalizedScorer
extends AbstractScorer {
    private Class<? extends AI_Zomis> aiClass;
    private Map<MinesweeperField, FieldScore> scores;

    @Override
    public String getName() {
        return super.getName() + "-" + this.aiClass.getSimpleName();
    }

    public AINormalizedScorer(Class<? extends AI_Zomis> aiClass) {
        this.aiClass = aiClass;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        MinesweeperPlayingPlayer player = scores.getPlayer();
        AI_Zomis instance = (AI_Zomis)scores.getPlayer().getMap().getMapFactory().ai(player, this.aiClass);
        FieldScores fscores = instance.createScoreProvider().analyzeAndScore(scores.getWeapon(), false);
        if (fscores == null) {
            this.scores = null;
            return false;
        }
        fscores.rankScores();
        this.scores = fscores.getScores();
        return true;
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        return this.scores.get(field).getNormalized();
    }
}

