/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.otherscorers;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class Easy100Scorer
extends AbstractScorer {
    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsClick(scores.getWeapon());
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        for (MinesweeperField inv : field.getInvertedNeighbors()) {
            if (this.unclickedNeighbors(inv) != ZomisTools.fieldNeedsMoreMines(inv)) continue;
            return 1.0;
        }
        return 0.0;
    }

    private int unclickedNeighbors(MinesweeperField field) {
        int i = 0;
        for (MinesweeperField ff : field.getNeighbors()) {
            if (ff.isClicked()) continue;
            ++i;
        }
        return i;
    }
}

