/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.mirror;

import java.util.List;
import net.zomis.minesweeper.ais.AI_Complete_Idiot;
import net.zomis.minesweeper.ais.AI_Extreme3;
import net.zomis.minesweeper.ais.AI_HardPlus;
import net.zomis.minesweeper.ais.AI_Medium;
import net.zomis.minesweeper.ais.AI_ZLoser;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.Disabled_AI_Horrible;
import net.zomis.minesweeper.ais.mirror.Analyze_AI_Mirror;
import net.zomis.minesweeper.ais.mirror.MirrorScorerAI;
import net.zomis.minesweeper.ais.mirror.MirrorScorerRating;
import net.zomis.minesweeper.analyze.endgame.PlayerUtils;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScoreProducer;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreProducer;

public class AI_Mirror
extends MinesweeperAI
implements ScoreProducer {
    private Analyze_AI_Mirror mirror;
    private int lastMove = 0;

    private void updateAnalyze() {
        if (this.mirror == null) {
            this.mirror = AI_Mirror.newMirror(this.getOpponent());
        }
        if (this.lastMove > this.getMap().getMoveHistory().size()) {
            this.mirror = AI_Mirror.newMirror(this.getOpponent());
            this.lastMove = 0;
        }
        List newMoves = this.getMap().getMoveHistory().subList(this.lastMove, this.getMap().getMoveHistory().size());
        for (MinesweeperMove move : newMoves) {
            if (move.getPlayer() == this.getPlayingPlayer()) continue;
            this.mirror.moveInform(move);
        }
        this.lastMove += newMoves.size();
    }

    private static Analyze_AI_Mirror newMirror(MinesweeperPlayingPlayer player) {
        Analyze_AI_Mirror mirr = new Analyze_AI_Mirror(player);
        mirr.addScorer(new MirrorScorerAI(player, AI_Extreme3.class)).addScorer(new MirrorScorerAI(player, AI_HardPlus.class)).addScorer(new MirrorScorerAI(player, AI_Medium.class)).addScorer(new MirrorScorerAI(player, AI_ZLoser.class)).addScorer(new MirrorScorerAI(player, Disabled_AI_Horrible.class)).addScorer(new MirrorScorerRating(mirr));
        return mirr;
    }

    private MinesweeperPlayingPlayer getOpponent() {
        return PlayerUtils.getLastPlayer(this.getPlayingPlayer());
    }

    public AI_Mirror(MinesweeperPlayingPlayer player) {
        super(player);
    }

    @Override
    public MinesweeperMove play() {
        this.updateAnalyze();
        if (this.mirror.getCount() <= 0) {
            return this.playAs(AI_Complete_Idiot.class);
        }
        this.sendChatMessage(this.mirror.toString());
        AI_Zomis ai = new AI_Zomis(this.getPlayingPlayer(), this.mirror.getScoreConfig()){};
        ai.setBackup(AI_Complete_Idiot.class);
        return ai.play();
    }

    public boolean respondToInvite(Invite invite) {
        return AI_Zomis.hostHasMoreRating(invite, this, 2500.0);
    }

    public boolean agreeDraw() {
        return MineprobHelper.isDraw(this.getMap());
    }

    @Override
    public ScoreConfig getConfig() {
        this.updateAnalyze();
        return this.mirror.getScoreConfig();
    }

    @Override
    public FieldScoreProducer createScoreProvider() {
        return new FieldScoreProducer(this.getPlayingPlayer(), this.getConfig());
    }
}

