/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.zomis.UtilZomisList;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.detail.DetailedResults;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class BombTools {
    private MinesweeperPlayingPlayer player;

    public BombTools(MinesweeperPlayingPlayer player) {
        this.player = player;
    }

    public static boolean isInterestingSolution(Solution<MinesweeperField> solution) {
        for (Map.Entry ee : solution.getSetGroupValues().entrySet()) {
            if (((FieldGroup)ee.getKey()).size() - (Integer)ee.getValue() == 1 || ((FieldGroup)ee.getKey()).size() > 8) continue;
            return true;
        }
        return false;
    }

    public static double getBombWinPercent(AnalyzeResult<MinesweeperField> analyze, MinesweeperField bombLocation, int score) {
        int remaining = bombLocation.getMap().getMinesLeft();
        int needed = 26 - score;
        List<MinesweeperField> adj = BombTools.getBombAdjacents(bombLocation);
        UtilZomisList.filter(adj, (UtilZomisList.FilterInterface)new UtilZomisList.FilterInterface<MinesweeperField>(){

            public boolean shouldKeep(MinesweeperField obj) {
                return !obj.isClicked();
            }
        });
        if (remaining > adj.size()) {
            remaining = adj.size();
        }
        double total = 0.0;
        for (int i = needed; i <= remaining; ++i) {
            ArrayList<FieldRule> list = new ArrayList<FieldRule>();
            FieldRule bombRule = new FieldRule((Object)bombLocation, adj, i);
            list.add(bombRule);
            double probI = analyze.getProbabilityOf(list);
            total += probI;
        }
        return total;
    }

    public MinesweeperMove checkBomb(DetailedResults<MinesweeperField> detailedAnalyze) {
        double highest = 0.0;
        MinesweeperField highestField = null;
        for (MinesweeperField ff : this.player.getMap().getIteration()) {
            double bombprob = this.calcBombProb(ff, detailedAnalyze);
            if (!(bombprob > highest)) continue;
            highest = bombprob;
            highestField = ff;
        }
        if ((double)this.player.getScore() + highest >= 25.5) {
            return this.player.createMove("B", highestField);
        }
        return null;
    }

    public double calcBombProb(MinesweeperField ff, DetailedResults<MinesweeperField> detailedAnalyze) {
        double total = 0.0;
        for (int xx = -2; xx <= 2; ++xx) {
            for (int yy = -2; yy <= 2; ++yy) {
                MinesweeperField relative = ff.getRelativePosition(xx, yy);
                if (relative == null || relative.isClicked()) continue;
                total += detailedAnalyze.getProxyFor((Object)relative).getMineProbability();
            }
        }
        return total;
    }

    public static List<MinesweeperField> getBombAdjacents(MinesweeperField field) {
        int RANGE = 2;
        int xpos = UtilZomisUtils.ensureRange((int)2, (int)field.getX(), (int)(field.getMap().getFieldWidth() - 2 - 1));
        int ypos = UtilZomisUtils.ensureRange((int)2, (int)field.getY(), (int)(field.getMap().getFieldHeight() - 2 - 1));
        field = field.getMap().getPosition(xpos, ypos);
        ArrayList<MinesweeperField> bombAdjacents = new ArrayList<MinesweeperField>();
        int x = field.getX();
        int y = field.getY();
        for (int yy = -2; yy <= 2; ++yy) {
            for (int xx = -2; xx <= 2; ++xx) {
                if (x + xx < 0 || x + xx >= field.getMap().getFieldWidth() || y + yy < 0 || y + yy >= field.getMap().getFieldHeight()) continue;
                bombAdjacents.add(field.getRelativePosition(xx, yy));
            }
        }
        return bombAdjacents;
    }

    public static MinesweeperField getBestBomb(MinesweeperMap map, AnalyzeResult<MinesweeperField> analyze) {
        double max = 0.0;
        MinesweeperField field = null;
        for (MinesweeperField ff : map.getIteration()) {
            double bomb = BombTools.getBombProbability(BombTools.getBombAdjacents(ff), analyze);
            if (!(bomb > max)) continue;
            field = ff;
            max = bomb;
        }
        return field;
    }

    public static double getBombProbability(MinesweeperField bombCenter, AnalyzeResult<MinesweeperField> analyze) {
        return BombTools.getBombProbability(BombTools.getBombAdjacents(bombCenter), analyze);
    }

    public static double getBombProbability(Collection<MinesweeperField> affected, AnalyzeResult<MinesweeperField> analyze) {
        double total = 0.0;
        for (MinesweeperField field : affected) {
            FieldGroup know;
            if (field.isClicked() || (know = analyze.getGroupFor((Object)field)) == null) continue;
            total += know.getProbability();
        }
        return total;
    }
}

