/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.classes;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import net.zomis.mario.classes.Point;

public class UnknownPoint {
    public int row;
    public int col;
    public Hashtable<Integer, Integer> times;
    public boolean tempMine;
    public int adjacentTempMines;
    public ArrayList<Integer> relKnown;
    public ArrayList<Integer> relZone;
    public ArrayList<Integer> relUnknown;
    public int[][] adjacents;
    private int maximumAdjacentMines = -1;

    public UnknownPoint(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public UnknownPoint(Point p) {
        this.row = p.row;
        this.col = p.col;
    }

    public UnknownPoint(int row, int col, int rel) {
        this.times = new Hashtable(5);
        this.relKnown = new ArrayList(8);
        this.relUnknown = new ArrayList(8);
        this.relZone = new ArrayList(8);
        this.row = row;
        this.col = col;
        this.tempMine = false;
        this.relKnown.add(rel);
    }

    public int MaxAdjacentMines() {
        if (this.maximumAdjacentMines != -1) {
            return this.maximumAdjacentMines;
        }
        this.maximumAdjacentMines = 0;
        for (int i = this.adjacents[0].length - 1; i > 0; --i) {
            for (int j = 0; j < this.adjacents.length; ++j) {
                if (this.adjacents[j][i] == 0) continue;
                this.maximumAdjacentMines = i;
                return i;
            }
        }
        return this.maximumAdjacentMines;
    }

    public int TotalTimes() {
        int totalTimes = 0;
        for (Map.Entry<Integer, Integer> keyValuePair : this.times.entrySet()) {
            totalTimes += keyValuePair.getValue().intValue();
        }
        return totalTimes;
    }

    public Point pointValue() {
        return new Point(this.row, this.col);
    }

    public String toString() {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("(" + this.row + "," + this.col + ")", new Object[0]));
        for (int k = 0; k < this.times.size(); ++k) {
            if (!this.times.contains(k)) continue;
            stringBuilder.append(String.format("\t[%d] %s", k, "value " + this.times.get(k)));
        }
        stringBuilder.append("\r\n\t\t\tKnownRelated\t(");
        for (i = 0; i < this.relKnown.size(); ++i) {
            stringBuilder.append("" + this.relKnown.get(i));
            if (i == this.relKnown.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        if (this.relZone.size() > 0) {
            stringBuilder.append("\r\n\t\t\tZoneRelated\t(");
            for (i = 0; i < this.relZone.size(); ++i) {
                stringBuilder.append(this.relZone.get(i));
                if (i == this.relZone.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        if (this.relUnknown.size() > 0) {
            stringBuilder.append("\r\n\t\t\tUnknownRelated\t(");
            for (i = 0; i < this.relUnknown.size(); ++i) {
                stringBuilder.append(this.relUnknown.get(i));
                if (i == this.relUnknown.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        if (this.adjacents != null) {
            stringBuilder.append("\r\n\t\t\tAdjacents\r\n");
            for (i = 0; i < this.adjacents.length; ++i) {
                stringBuilder.append("\t\t\t");
                for (int j = 0; j < this.adjacents[0].length; ++j) {
                    stringBuilder.append(Integer.valueOf(this.adjacents[i][j]).toString());
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof UnknownPoint)) {
            return false;
        }
        UnknownPoint up = (UnknownPoint)other;
        return up.row == this.row && up.col == this.col;
    }
}

