/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;

public class OpenFieldApproxer {
    private double totalProb = 0.0;
    private AnalyzeProvider analyze;

    public double floodFill(AnalyzeProvider analyze, MinesweeperField field) {
        ArrayList ff = new ArrayList();
        this.totalProb = 0.0;
        this.analyze = analyze;
        UtilZomisUtils.recursiveAdd(ff, (Object)field, (UtilZomisUtils.RecursiveInterface)new Recursive());
        return this.totalProb - this.closestMineprobSum(analyze, field);
    }

    private double closestMineprobSum(AnalyzeProvider analyze, MinesweeperField field) {
        double total = 0.0;
        Collection fields = field.getNeighbors();
        fields.add(field);
        for (MinesweeperField ff : fields) {
            ProbabilityKnowledge<MinesweeperField> know = analyze.getKnowledgeFor(ff);
            if (know == null) continue;
            total += know.getMineProbability();
        }
        return total;
    }

    public double expectedFrom(AnalyzeProvider analyze, MinesweeperField field) {
        if (field.isClicked()) {
            return 0.0;
        }
        LinkedList<MinesweeperField> nextQ = new LinkedList<MinesweeperField>();
        HashSet<MinesweeperField> completed = new HashSet<MinesweeperField>();
        HashSet<MinesweeperField> finalFields = new HashSet<MinesweeperField>();
        double total = analyze.getKnowledgeFor(field).getMineProbability();
        int iterations = 0;
        nextQ.add(field);
        while (iterations < 3) {
            ++iterations;
            LinkedList<MinesweeperField> queue = nextQ;
            nextQ = new LinkedList();
            boolean foundProbability = false;
            if (queue.isEmpty()) break;
            while (!queue.isEmpty()) {
                MinesweeperField next = (MinesweeperField)queue.poll();
                completed.add(next);
                for (MinesweeperField ff : next.getNeighbors()) {
                    ProbabilityKnowledge<MinesweeperField> probData = analyze.getKnowledgeFor(ff);
                    if (!(ff.isClicked() || nextQ.contains(ff) || queue.contains(ff) || completed.contains(ff))) {
                        if (probData.getProbabilities()[0] < 1.0) {
                            finalFields.add(ff);
                        }
                        if (probData.getProbabilities()[0] <= 0.0) continue;
                        nextQ.add(ff);
                        if (probData == null) continue;
                        total += probData.getMineProbability();
                        if (probData.getMineProbability() == 0.0) continue;
                        foundProbability = true;
                        continue;
                    }
                    if (!ff.isClicked()) continue;
                    finalFields.add(ff);
                }
            }
            if (foundProbability) continue;
            --iterations;
        }
        HashSet<MinesweeperField> extras = new HashSet<MinesweeperField>();
        total = analyze.getKnowledgeFor(field).getMineProbability();
        for (MinesweeperField finalField : finalFields) {
            for (MinesweeperField neighbor : finalField.getNeighbors()) {
                if (neighbor.isClicked() || extras.contains(neighbor)) continue;
                extras.add(neighbor);
                total += analyze.getKnowledgeFor(neighbor).getMineProbability();
            }
        }
        return -analyze.getKnowledgeFor(field).getMineProbability() * 2.0 + total - this.closestMineprobSum(analyze, field);
    }

    private class Recursive
    implements UtilZomisUtils.RecursiveInterface<MinesweeperField> {
        private Set<MinesweeperField> added = new HashSet<MinesweeperField>();

        private Recursive() {
        }

        public boolean performAdd(MinesweeperField from, MinesweeperField to) {
            if (to.isClicked()) {
                return false;
            }
            if (OpenFieldApproxer.this.analyze.getKnowledgeFor(to) == null) {
                return false;
            }
            if (OpenFieldApproxer.this.analyze.getKnowledgeFor(to).getProbabilities()[0] <= 0.0) {
                return false;
            }
            if (this.added.contains(to)) {
                return false;
            }
            this.added.add(to);
            OpenFieldApproxer.this.totalProb = OpenFieldApproxer.this.totalProb + OpenFieldApproxer.this.analyze.getKnowledgeFor(to).getMineProbability();
            return true;
        }

        public boolean performRecursive(MinesweeperField from, MinesweeperField to) {
            return !to.isClicked() && OpenFieldApproxer.this.analyze.getKnowledgeFor(to) != null && OpenFieldApproxer.this.analyze.getKnowledgeFor(to).getProbabilities()[0] > 0.0;
        }

        public Collection<MinesweeperField> getRecursiveFields(MinesweeperField field) {
            return field.getNeighbors();
        }
    }
}

