/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class SafeProbabilityAroundMine
extends AbstractScorer {
    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        if (!this.isInterestingField(field, data, scores.getWeapon())) {
            return 0.0;
        }
        if (!ZomisTools.isZomisOpenField(field)) {
            return 0.0;
        }
        double[] probabilities = data.getProbabilities();
        for (int i = probabilities.length - 1; i >= 0; --i) {
            if (!(probabilities[i] > 0.0)) continue;
            double prob = data.getMineProbability() - probabilities[i] * (double)(i - data.getFound());
            return prob / 10.0;
        }
        if (data.getMineProbability() > 0.99) {
            return 0.0;
        }
        throw new AssertionError((Object)("Something is horribly wrong with these probabilities: " + data));
    }

    public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
        return data.getMineProbability() > 0.0 && (data.getFound() > 0 || data.getProbabilities()[0] == 0.0);
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsClick(scores.getWeapon());
    }
}

