/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.OpenFieldApproxer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class NonRevealingSafeClicks
extends AbstractScorer {
    private OpenFieldApproxer openFieldScan = new OpenFieldApproxer();

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        if (this.isInterestingField(field, data, scores)) {
            return 0.01;
        }
        return 0.0;
    }

    public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        for (int i = 0; i < data.getProbabilities().length; ++i) {
            if (data.getProbabilities()[i] != 1.0) continue;
            if (i == 0) {
                return this.openFieldScan.floodFill(scores.getAnalyze(), field) == 0.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsClick(scores.getWeapon());
    }
}

