/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.utils;

import java.util.ArrayList;
import java.util.List;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;

public class AICompare {
    private final MinesweeperMap map;
    private final List<Class<? extends AI_Zomis>> ais;

    @SafeVarargs
    public AICompare(MinesweeperMap map, Class<? extends AI_Zomis> ... ais) {
        this.map = map;
        this.ais = new ArrayList<Class<? extends AI_Zomis>>(ais.length);
        for (Class<? extends AI_Zomis> ai : ais) {
            this.ais.add(ai);
        }
    }

    private boolean compareNext(boolean performMove) {
        ArrayList<AI_Zomis> realAIs = new ArrayList<AI_Zomis>();
        for (Class<? extends AI_Zomis> ai : this.ais) {
            AI_Zomis realAI = (AI_Zomis)this.map.getMapFactory().ai(this.map.getCurrentPlayer(), ai);
            realAIs.add(realAI);
        }
        if (realAIs.size() != this.ais.size()) {
            throw new IllegalStateException();
        }
        ArrayList<List<FieldScore>> bestRankings = new ArrayList<List<FieldScore>>();
        MinesweeperMove theMove = null;
        for (AI_Zomis aI_Zomis : realAIs) {
            MinesweeperMove move = aI_Zomis.play();
            if (move == null) {
                throw new AssertionError((Object)"move null");
            }
            FieldScores fieldScores = aI_Zomis.createScoreProvider().analyzeAndScore(move.getWeapon(), false);
            theMove = move;
            List<FieldScore> rankings = fieldScores.getBestFields();
            bestRankings.add(rankings);
        }
        for (List list : bestRankings) {
            for (List list2 : bestRankings) {
                if (FieldScores.listsEquals(list, list2)) continue;
                return false;
            }
        }
        if (performMove) {
            if (!theMove.getMap().performMove(theMove).isOK()) {
                throw new IllegalStateException("Could not make move " + theMove);
            }
        } else if (!theMove.getMoveAllowedState().isOK()) {
            throw new IllegalStateException("Impossible move returned " + theMove);
        }
        return true;
    }

    public boolean compareNext() {
        return this.compareNext(true);
    }

    public boolean solveConflict() {
        if (!this.compareNext(false)) {
            AI_Zomis ai = (AI_Zomis)this.map.getMapFactory().ai(this.map.getCurrentPlayer(), (Class)UtilZomisList.getRandom(this.ais));
            MinesweeperMove move = ai.play();
            return move.getMap().performMove(move).isOK();
        }
        return false;
    }
}

