/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.otherscorers;

import java.util.Collection;
import java.util.Random;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RandomBomber
extends AbstractScorer {
    private Random random = new Random();

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsBomb(scores.getWeapon()) && this.ereDags(scores.getPlayer());
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        return this.unclicked(scores.getWeapon().getFieldsAffected(scores.getPlayer(), field));
    }

    private double unclicked(Collection<MinesweeperField> fieldsAffected) {
        int i = 0;
        for (MinesweeperField ff : fieldsAffected) {
            if (ff.isClicked()) continue;
            ++i;
        }
        return i;
    }

    private boolean ereDags(MinesweeperPlayingPlayer player) {
        if (this.random.nextInt(100) < 42) {
            int avarage = 0;
            for (int i = 0; i < player.getMap().getPlayingPlayers().size(); ++i) {
                avarage += ((MinesweeperPlayingPlayer)player.getMap().getPlayingPlayers().get(i)).getScore();
            }
            if (player.getMap().getCurrentPlayer().getScore() < (avarage /= player.getMap().getPlayingPlayers().size()) - (this.random.nextInt(3) + 2)) {
                return true;
            }
            if ((double)RandomBomber.getHighestScore(player.getMap()) >= (double)player.getMap().getMinesCount() * 0.4) {
                return true;
            }
        }
        return false;
    }

    private static int getHighestScore(MinesweeperMap map) {
        for (MinesweeperPlayingPlayer player : map.getPlayingPlayers()) {
            if (!player.hasMostScore()) continue;
            return player.getScore();
        }
        return 42;
    }
}

