/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mfe.plugin;

import java.util.Collection;
import net.zomis.UtilZomisUtils;
import net.zomis.mario.mfeais.AbstractMarioBot;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.mario.mfeais.Slow_AI_Mario_A2;
import net.zomis.minesweeper.ais.AI_Nightmare;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.ais.mirror.AI_Mirror;
import net.zomis.minesweeper.ais.test.AI_Debug;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.events.player.PlayerLoginEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.PreScorer;

public class NightmarePlugin
extends MinesweeperPlugin
implements EventListener {
    @Event
    public void gameCheckMirror(InvitePreStartEvent event) {
        for (MinesweeperPlayer player : event.getInvite().getPlayers()) {
            if (player.isAI() && player.getName().contentEquals("#" + AI_Mirror.class.getSimpleName())) {
                event.getInvite().setRating(false);
            }
            if (!player.isAI() || !player.getName().contentEquals("#" + AI_Debug.class.getSimpleName())) continue;
            event.getInvite().setRating(false);
        }
    }

    @Event
    public void gameCheckMarioCompatibility(InviteGameStartingEvent event) {
        if (!event.getInvite().getHost().isRealPlayer()) {
            return;
        }
        String marioAI = null;
        MinesweeperGame map = event.getGame();
        for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
            if (!(pp.getAI() instanceof AI_Zomis)) continue;
            AI_Zomis ai = (AI_Zomis)pp.getAI();
            for (PreScorer scorer : ai.getConfig().getPreScorers()) {
                if (!(scorer instanceof MarioAnalyze)) continue;
                marioAI = ai.getName();
            }
        }
        if (marioAI == null) {
            return;
        }
        MinesweeperField field = map.getPosition(1, 1);
        Collection neighbors = field.getNeighbors();
        if (neighbors.size() != 8) {
            event.setCancelled(true);
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0 || neighbors.contains(field.getRelativePosition(x, y))) continue;
                    event.setCancelled(true);
                }
            }
        }
        for (MinesweeperField ff : map.getIteration()) {
            if (!ff.isBlocked()) continue;
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            for (MinesweeperPlayer player : event.getInvite().getPlayers()) {
                player.sendAlert(marioAI + " can not play with plugins: " + UtilZomisUtils.implode((String)", ", (Iterable)event.getInvite().getPlugins()));
            }
        }
    }

    @Event
    public void login(PlayerLoginEvent event) {
        String mess = "Can you beat #" + AI_Nightmare.class.getSimpleName() + " ?";
        if (event.getPlayer().isClientFlash()) {
            event.getPlayer().sendChat(mess + " You can play the AIs by double-clicking the name in the list to the right!", Integer.valueOf(0xFFFF00));
        } else {
            event.getPlayer().sendChat(mess);
        }
        event.getPlayer().sendChat("Please don't play against yourself to get rating. You will get caught.", Integer.valueOf(0xFFFF00));
        event.getPlayer().sendChat("A football team does not leave the field if they are going to lose. It's good sportsmanship to finish a game even if you are losing.", Integer.valueOf(0xFFFF00));
        if (event.getPlayer().hasPermission("DONATOR") && !event.getPlayer().hasPermission("ADMIN")) {
            event.getServer().broadcastLobbyChat("#Server: #Server gives a donut to " + event.getPlayer().getDisplayName() + " for being a donator!");
        }
    }

    @Command(command="night", help="Test Mario's code's view of the board", requiredPermission="TRUSTED")
    public void chat(PlayerCommandEvent event) {
        if (event.getParameter(0).contentEquals("time")) {
            Slow_AI_Mario_A2 mario = new Slow_AI_Mario_A2(event.getMap().getCurrentPlayer());
            char[][] board = NightmareTools.fixBoard(mario.getPlayingPlayer(), mario.getBot());
            long time = System.nanoTime();
            mario.getBot().move(board);
            time = System.nanoTime() - time;
            event.getPlayer().sendChat("Mario's code took " + MineprobHelper.nanoToMilli(time) + " milliseconds.");
            return;
        }
        for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
            if (!pp.isAI() || !(pp.getAI() instanceof AbstractMarioBot)) continue;
            AbstractMarioBot nightmare = (AbstractMarioBot)pp.getAI();
            nightmare.respondTo(event);
            return;
        }
        Slow_AI_Mario_A2 bot = new Slow_AI_Mario_A2(event.getMap().getCurrentPlayer());
        bot.play();
        bot.respondTo(event);
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return false;
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener(this);
    }
}

