/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.probability;

import net.zomis.mario.classes.Configuration;

public final class HyperGeometricDistribution {
    static final HyperGeometricDistribution instance = new HyperGeometricDistribution();
    public double[][][][] probability;
    public double[][] auxKD;
    public double[][] auxMinesK;
    boolean isInitialized;
    int maxO;
    int maxM;
    static final int maxD = 26;
    static final int maxk = 26;

    private HyperGeometricDistribution() {
        this.maxO = Configuration.BasicConfig().DIMH * Configuration.BasicConfig().DIMV + 1;
        this.maxM = Configuration.BasicConfig().MINES + 1;
    }

    public void Initialize() {
        if (!this.isInitialized) {
            this.probability = new double[26][26][this.maxM][this.maxO];
            this.auxKD = new double[26][26];
            this.auxMinesK = new double[this.maxM][26];
            this.PreCalculateKD();
            this.PreCalculateMinesK();
            this.Calculate();
        }
        this.isInitialized = true;
    }

    public static HyperGeometricDistribution getInstance() {
        return instance;
    }

    public double getthis(int k, int D, int mines, int opensea) {
        return HyperGeometricDistribution.instance.probability[k][D][mines][opensea];
    }

    void Calculate() {
        for (int opensea = 0; opensea < this.maxO; ++opensea) {
            for (int mines = 0; mines <= opensea && mines < this.maxM; ++mines) {
                for (int d = 0; d < 26 && d <= opensea; ++d) {
                    for (int k = 0; k <= d; ++k) {
                        this.probability[k][d][mines][opensea] = this.CalculateHypergeometricValue(k, d, mines, opensea);
                    }
                }
            }
        }
    }

    void PreCalculateKD() {
        for (int k = 0; k < 26; ++k) {
            for (int d = k; d < 26; ++d) {
                int i;
                double factorial = 1.0;
                for (i = d - k + 1; i <= d; ++i) {
                    factorial *= (double)i;
                }
                for (i = 2; i <= k; ++i) {
                    factorial /= (double)i;
                }
                this.auxKD[k][d] = factorial;
            }
        }
    }

    void PreCalculateMinesK() {
        for (int mines = 0; mines < this.maxM; ++mines) {
            for (int k = 0; k < 26 && k <= mines; ++k) {
                double factorial = 1.0;
                for (int i = mines - k + 1; i <= mines; ++i) {
                    factorial *= (double)i;
                }
                this.auxMinesK[mines][k] = factorial;
            }
        }
    }

    double CalculateHypergeometricValue(int k, int d, int mines, int opensea) {
        int i;
        double factorial = this.auxKD[k][d] * this.auxMinesK[mines][k];
        for (i = opensea - d + 1; i <= opensea; ++i) {
            factorial /= (double)i;
        }
        for (i = opensea - d - mines + k + 1; i <= opensea - mines; ++i) {
            factorial *= (double)i;
        }
        return factorial;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("HYPERGEOMETRIC DISTRIBUTION [mines,opensea]\r\n");
        for (int opensea = 0; opensea < this.maxO; ++opensea) {
            for (int mines = 0; mines < this.maxM && mines <= opensea; ++mines) {
                stringBuilder.append(String.format("[%d,%d]\r\n", mines, opensea));
                for (int k = 0; k < 26 && k <= mines; ++k) {
                    for (int d = 0; d < 26 && d <= opensea; ++d) {
                        stringBuilder.append(String.format("SKITSAMMA", new Object[0]));
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

