/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.scores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.zomis.UtilZomisList;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.MapUtils;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.PostScorer;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class FieldScores
implements ScoreParameters {
    private final MinesweeperWeapon weapon;
    private AnalyzeProvider analyze;
    private final MinesweeperPlayingPlayer player;
    private List<AbstractScorer> activeScorers;
    private final ScoreConfig config;
    private Map<Class<?>, Object> analyzes;
    private final Map<MinesweeperField, FieldScore> scores = new HashMap<MinesweeperField, FieldScore>();
    private MinesweeperField[][] ranks;
    private List<List<FieldScore>> rankedScores;

    @Override
    public <E> E getAnalyze(Class<E> clazz) {
        return (E)this.analyzes.get(clazz);
    }

    FieldScores(MinesweeperPlayingPlayer player, MinesweeperWeapon weapon, ScoreConfig config) {
        this.weapon = weapon;
        this.player = player;
        this.config = config;
    }

    @Override
    public MinesweeperWeapon getWeapon() {
        return this.weapon;
    }

    void determineActiveScorers() {
        if (this.activeScorers != null) {
            throw new IllegalStateException();
        }
        this.activeScorers = new ArrayList<AbstractScorer>();
        for (AbstractScorer scorer : this.config.getScorers().keySet()) {
            if (!scorer.workWithWeapon(this)) continue;
            this.activeScorers.add(scorer);
        }
    }

    void calculateMoveScores() {
        for (MinesweeperField field : this.player.getMap().getAllFields()) {
            if (!this.weapon.canUseAt(this.player, field)) continue;
            FieldScore fscore = new FieldScore(field);
            ProbabilityKnowledge<MinesweeperField> data = this.analyze == null ? null : this.analyze.getKnowledgeFor(field);
            for (AbstractScorer scorer : this.activeScorers) {
                double lastScore = scorer.getScoreFor(field, data, this);
                fscore.addScore(scorer, lastScore, (Double)this.config.getScorers().get(scorer));
            }
            this.scores.put(field, fscore);
        }
    }

    void calculateRankings() {
        SortedSet sorted = UtilZomisList.entriesSortedByValues(this.scores, (boolean)true);
        int index = 0;
        Double lastValue = null;
        for (Map.Entry ee : sorted) {
            if (lastValue != null && ((FieldScore)ee.getValue()).getScore() == lastValue.doubleValue()) continue;
            lastValue = ((FieldScore)ee.getValue()).getScore();
            ++index;
        }
        int highestIndex = index;
        this.ranks = new MinesweeperField[highestIndex + 1][];
        index = 0;
        ArrayList<MinesweeperField> list = null;
        lastValue = null;
        for (Map.Entry ee : sorted) {
            MinesweeperField field = (MinesweeperField)ee.getKey();
            if (lastValue == null || ((FieldScore)ee.getValue()).getScore() != lastValue.doubleValue()) {
                lastValue = ((FieldScore)ee.getValue()).getScore();
                if (list != null) {
                    this.ranks[index - 1] = list.toArray(new MinesweeperField[list.size()]);
                }
                ++index;
                list = new ArrayList<MinesweeperField>();
            }
            list.add(field);
        }
        if (list != null) {
            this.ranks[index - 1] = list.toArray(new MinesweeperField[list.size()]);
        }
    }

    void postHandle() {
        for (PostScorer post : this.config.getPostScorers()) {
            post.handle(this);
        }
    }

    void setAnalyze(AnalyzeProvider analyze) {
        this.analyze = analyze;
    }

    @Override
    public AnalyzeProvider getAnalyze() {
        return this.analyze;
    }

    @Override
    public MinesweeperPlayingPlayer getPlayer() {
        return this.player;
    }

    public MinesweeperField[][] getRankings() {
        return this.ranks;
    }

    public Map<MinesweeperField, FieldScore> getScores() {
        return this.scores;
    }

    public List<FieldScore> getBestFields() {
        return UtilZomisList.getAllExtreme(this.scores.values(), (double)-2.147483648E9, (UtilZomisList.GetValueInterface)new _GetValueFieldScore());
    }

    public FieldScore getScoreFor(MinesweeperField field) {
        return this.scores.get(field);
    }

    public double getNormalized(MinesweeperField field) {
        if (this.scores.get(field) == null) {
            throw new IllegalArgumentException("Field does not exist among scores: " + field + " in map: " + MapUtils.saveKnownMap((MinesweeperMap)field.getMap()));
        }
        SortedSet sorted = UtilZomisList.entriesSortedByValues(this.scores, (boolean)true);
        double max = ((FieldScore)((Map.Entry)sorted.first()).getValue()).getScore();
        double min = ((FieldScore)((Map.Entry)sorted.last()).getValue()).getScore();
        double range = max - min;
        return UtilZomisUtils.normalized((double)this.scores.get(field).getScore(), (double)min, (double)range);
    }

    public void normalize() {
    }

    public static boolean listsEquals(List<FieldScore> a, List<FieldScore> b) {
        List<MinesweeperField> temp = FieldScores.scoresToFields(a);
        temp.removeAll(b);
        if (!temp.isEmpty()) {
            return false;
        }
        temp = FieldScores.scoresToFields(b);
        temp.removeAll(a);
        return temp.isEmpty();
    }

    public static List<MinesweeperField> scoresToFields(List<FieldScore> scoreList) {
        ArrayList<MinesweeperField> list = new ArrayList<MinesweeperField>();
        for (FieldScore score : scoreList) {
            list.add(score.getField());
        }
        return list;
    }

    public void rankScores() {
        SortedSet sorted = UtilZomisList.entriesSortedByValues(this.scores, (boolean)true);
        this.rankedScores = new LinkedList<List<FieldScore>>();
        if (sorted.isEmpty()) {
            return;
        }
        double minScore = ((FieldScore)((Map.Entry)sorted.last()).getValue()).getScore();
        double maxScore = ((FieldScore)((Map.Entry)sorted.first()).getValue()).getScore();
        double lastScore = maxScore + 1.0;
        int rank = 0;
        LinkedList currentRank = new LinkedList();
        for (Map.Entry score : sorted) {
            if (lastScore != ((FieldScore)score.getValue()).getScore()) {
                lastScore = ((FieldScore)score.getValue()).getScore();
                ++rank;
                currentRank = new LinkedList();
                this.rankedScores.add(currentRank);
            }
            ((FieldScore)score.getValue()).setRank(rank);
            double normalized = UtilZomisUtils.normalized((double)((FieldScore)score.getValue()).getScore(), (double)minScore, (double)(maxScore - minScore));
            ((FieldScore)score.getValue()).setNormalized(normalized);
            currentRank.add(score.getValue());
        }
    }

    public List<FieldScore> getRank(int rank) {
        return this.rankedScores.get(rank - 1);
    }

    public int getRankCount() {
        return this.rankedScores.size();
    }

    public ScoreConfig getConfig() {
        return this.config;
    }

    public void setAnalyzes(Map<Class<?>, Object> analyzes) {
        this.analyzes = new HashMap(analyzes);
    }

    private static class _GetValueFieldScore
    implements UtilZomisList.GetValueInterface<FieldScore> {
        private _GetValueFieldScore() {
        }

        public double getValue(FieldScore obj) {
            return obj.getScore();
        }
    }
}

