/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.scores;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.scores.Scorer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class AbstractScorer
extends Scorer {
    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected boolean weaponIsClick(MinesweeperWeapon weapon) {
        if (weapon == null) {
            return false;
        }
        return weapon.getWeaponType().contentEquals("P");
    }

    protected boolean weaponIsBomb(MinesweeperWeapon weapon) {
        if (weapon == null) {
            return false;
        }
        return weapon.getWeaponType().contentEquals("B");
    }

    public abstract boolean workWithWeapon(ScoreParameters var1);

    public abstract double getScoreFor(MinesweeperField var1, ProbabilityKnowledge<MinesweeperField> var2, ScoreParameters var3);

    protected static boolean hasProbability(double probability, double d) {
        return Math.abs(probability - d) < 1.0E-5;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

