/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;

public class OpenField {
    private Collection<MinesweeperField> openFields = new ArrayList<MinesweeperField>();
    private Collection<MinesweeperField> neighbors = new ArrayList<MinesweeperField>();

    public MinesweeperField getOpenFieldSource() {
        return new ArrayList<MinesweeperField>(this.openFields).get(0);
    }

    public List<MinesweeperField> getNeighbors() {
        return new ArrayList<MinesweeperField>(this.neighbors);
    }

    public boolean isEven() {
        return this.neighbors.size() % 2 == 0;
    }

    private OpenField() {
    }

    public boolean hasField(MinesweeperField field) {
        return this.openFields.contains(field) || this.neighbors.contains(field);
    }

    public static OpenField construct(AnalyzeProvider analyze, ProbabilityKnowledge<MinesweeperField> know) {
        if (know.getProbabilities()[0] != 1.0) {
            throw new IllegalArgumentException();
        }
        OpenField of = new OpenField();
        of.recursiveAdd(analyze, (MinesweeperField)know.getField());
        return of;
    }

    private void recursiveAdd(AnalyzeProvider analyze, MinesweeperField field) {
        if (this.hasField(field)) {
            return;
        }
        ProbabilityKnowledge<MinesweeperField> know = analyze.getKnowledgeFor(field);
        if (know.getProbabilities()[0] == 1.0) {
            this.openFields.add(field);
            for (MinesweeperField neighbor : field.getNeighbors()) {
                if (neighbor.isClicked()) continue;
                this.recursiveAdd(analyze, neighbor);
            }
        } else {
            Integer i = MineprobHelper.getCertainValue(know);
            if (i != null) {
                this.neighbors.add(field);
            }
        }
    }

    public String toString() {
        return "[OF: open: " + UtilZomisUtils.implode((String)", ", this.openFields) + ", neighbors: " + UtilZomisUtils.implode((String)", ", this.neighbors) + "]";
    }
}

