/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import net.zomis.mario.classes.Board;
import net.zomis.mario.mfeais.Slow_AI_Mario_A2;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;

public class ProbabilityZomisVsMario
extends MinesweeperPlugin
implements EventListener {
    @Command(command="probtest", help="Test AI analyze code by Zomis vs. analyze by Mario", requiredPermission="ADMIN")
    public void testZomisMario(PlayerCommandEvent event) {
        MinesweeperGame game = event.getGame();
        MinesweeperPlayer sendPlayer = event.getServer().getPlayerByName("#AI_Hard");
        long time = this.getTime();
        AnalyzeResult analyze = new MineprobabilityAnalyze((MinesweeperMap)game).solve();
        time = this.getTime() - time;
        event.getPlayer().sendChatBy("Time spent: " + time, sendPlayer);
        long timeAIHard = time;
        sendPlayer = event.getServer().getPlayerByName("#" + Slow_AI_Mario_A2.class.getSimpleName());
        time = this.getTime();
        Slow_AI_Mario_A2 aiMario = new Slow_AI_Mario_A2(game.getCurrentPlayer());
        aiMario.play();
        time = this.getTime() - time;
        Board marioBoard = aiMario.getBot().getBoard();
        double[][][] marioProbs = marioBoard.Probability();
        int breaks = 0;
        for (MinesweeperField ff : game.getIteration()) {
            double diff;
            if (!(marioProbs[ff.getY()][ff.getX()][9] > 0.0) && analyze.getGroupFor((Object)ff) == null || !(Math.abs(diff = analyze.getGroupFor((Object)ff).getProbability() - marioProbs[ff.getY()][ff.getX()][9]) > 1.0E-5)) continue;
            ++breaks;
            event.getPlayer().sendChatBy(String.format("DIFFERENCE! (%d, %d): %f vs. %f", ff.getX(), ff.getY(), analyze.getGroupFor((Object)ff).getProbability(), marioProbs[ff.getY()][ff.getX()][9]), sendPlayer, Integer.valueOf(0xFF0000));
        }
        event.getPlayer().sendChatBy("Total Mismatches: " + breaks, sendPlayer);
        long timeAIMario = time;
        event.getPlayer().sendChatBy("Time spent: " + time, sendPlayer);
        long diffTime = timeAIMario - timeAIHard;
        if (diffTime > 0L) {
            event.getPlayer().sendChatBy("AI Hard wins by " + diffTime + " ms", event.getServer().getServerPlayer());
        } else {
            event.getPlayer().sendChatBy("Mario wins by " + diffTime + " ms", event.getServer().getServerPlayer());
        }
    }

    private long getTime() {
        return System.nanoTime();
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return false;
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener(this);
    }
}

