/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore;

import java.util.Map;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class SafeWithRiskAroundMine
extends AbstractScorer {
    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        Map.Entry theEntry;
        if (data.getMineProbability() > 0.0) {
            return 0.0;
        }
        if (data.getProbabilities()[0] == 1.0) {
            return 0.0;
        }
        if (data.getNeighbors().size() == 1 && ((Integer)(theEntry = (Map.Entry)data.getNeighbors().entrySet().iterator().next()).getValue()).intValue() == ((FieldGroup)theEntry.getKey()).size()) {
            return -0.01;
        }
        if (!this.isInterestingField(field, data, scores.getWeapon())) {
            return -2.0;
        }
        double total = 0.0;
        for (MinesweeperField neighbor : field.getNeighbors()) {
            ProbabilityKnowledge<MinesweeperField> neighborData;
            if (neighbor.isClicked() || (neighborData = scores.getAnalyze().getKnowledgeFor(neighbor)) == null) continue;
            total += neighborData.getMineProbability();
        }
        return -total * 0.1;
    }

    public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
        return data.getProbabilities()[0] == 0.0 && data.getMineProbability() == 0.0;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        MarioAnalyze mario = scores.getAnalyze(MarioAnalyze.class);
        if (mario == null) {
            return this.weaponIsClick(scores.getWeapon());
        }
        return this.weaponIsClick(scores.getWeapon()) && mario.getBot().getBoard().MaxExpectedValue() <= 0.0;
    }
}

