/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.post;

import java.util.List;
import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.aiscore.CertainMines;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.PostScorer;
import net.zomis.weapons.classic.BombWeapon;

public class BombStifle
extends PostScorer {
    @Override
    public void handle(FieldScores scores) {
        if (!this.weaponIsClick(scores.getWeapon())) {
            return;
        }
        MinesweeperPlayingPlayer player = scores.getPlayer();
        String bomb = "B";
        MinesweeperPlayingPlayer opponent = MineprobHelper.getOpponents(scores.getPlayer())[0];
        if (opponent.getScore() > player.getScore()) {
            return;
        }
        BombWeapon bombWeapon = (BombWeapon)opponent.getWeapon(bomb);
        if (bombWeapon == null) {
            return;
        }
        if (bombWeapon.getUseCount() > 0) {
            return;
        }
        if (player.getScore() < 15) {
            return;
        }
        if (opponent.getScore() < 15) {
            return;
        }
        if (player.getScore() == opponent.getScore() && player.getMap().getMinesLeft() == 1) {
            return;
        }
        MinesweeperField bestBombField = BombTools.getBestBomb(player.getMap(), scores.getAnalyze().getAnalyze());
        List<MinesweeperField> bestAffected = BombTools.getBombAdjacents(bestBombField);
        double bombWinChance = BombTools.getBombWinPercent(scores.getAnalyze().getAnalyze(), bestBombField, opponent.getScore());
        MinesweeperField bestField = scores.getRankings()[0][0];
        ProbabilityKnowledge<MinesweeperField> bestData = scores.getAnalyze().getKnowledgeFor(bestField);
        if (bestData.getProbabilities()[0] > 0.0 && bestData.getProbabilities()[0] < 0.15 && bombWinChance >= 0.3) {
            this.performAddBombScore(scores, bestAffected);
        }
        if (bombWinChance >= 0.42) {
            if (opponent.getScore() == player.getScore()) {
                BombWeapon myWeapon = (BombWeapon)player.getWeapon(bomb);
                if (myWeapon.getUseCount() == 0) {
                    this.performAvoidGiveBomb(scores);
                }
            } else {
                this.performAddBombScore(scores, bestAffected);
            }
        }
    }

    private void performAddBombScore(FieldScores scores, List<MinesweeperField> bestBombEffect) {
        for (FieldScore ee : scores.getScores().values()) {
            double stifle = BombStifle.stifleEffect(ee.getField(), scores.getAnalyze(), bestBombEffect);
            if (stifle != 0.0) {
                // empty if block
            }
            this.force(ee, stifle);
        }
    }

    public static double stifleEffect(MinesweeperField field, AnalyzeProvider analyze, List<MinesweeperField> bestBombEffect) {
        if (bestBombEffect != null && !bestBombEffect.contains(field)) {
            return 0.0;
        }
        double bombScore = BombTools.getBombProbability(field, analyze.getAnalyze());
        if (analyze.getKnowledgeFor(field) == null) {
            return -42.0;
        }
        double bonusMineProbability = analyze.getKnowledgeFor(field).getMineProbability();
        double bonusAvoidOpenField = 1.0 - analyze.getKnowledgeFor(field).getProbabilities()[0];
        return bombScore * 2.0 + bonusMineProbability * 10.0 + bonusAvoidOpenField * 3.0;
    }

    private void performAvoidGiveBomb(FieldScores scores) {
        for (FieldScore ee : scores.getScores().values()) {
            ProbabilityKnowledge<MinesweeperField> data = scores.getAnalyze().getKnowledgeFor(ee.getField());
            this.force(ee, -data.getMineProbability() * CertainMines.POWER);
        }
        MinesweeperPlayingPlayer me = scores.getPlayer();
        MinesweeperPlayingPlayer opponent = MineprobHelper.getOpponents(scores.getPlayer())[0];
        int mines100 = MineprobHelper.find100(scores.getAnalyze().getAnalyze());
        if (me.getScore() == opponent.getScore() && me.getScore() + mines100 + 1 >= 26) {
            List<FieldScore> best = scores.getBestFields();
            if (scores.getAnalyze().getKnowledgeFor(best.get(0).getField()).getMineProbability() > 0.0) {
                for (FieldScore ee : scores.getScores().values()) {
                    ProbabilityKnowledge<MinesweeperField> data = scores.getAnalyze().getKnowledgeFor(ee.getField());
                    if (!(data.getMineProbability() < 1.0)) continue;
                    this.force(ee, data.getMineProbability() * 20.0);
                }
            }
        }
    }
}

