/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mfe.plugin;

import java.util.ArrayList;
import java.util.Random;
import net.zomis.UtilZomisList;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import org.apache.log4j.Logger;

public class TentaizuListener
implements EventListener {
    private static final Logger logger = Logger.getLogger(TentaizuListener.class);
    private TentaizuValidator validOne = new TentaizuValidator(){

        @Override
        public boolean isValid(MinesweeperField field, AnalyzeResult<MinesweeperField> before, AnalyzeResult<MinesweeperField> analyze) {
            return analyze.getTotal() <= before.getTotal();
        }
    };

    @Command(command="tentaizu", help="Hide squares if possible without having too many solutions on the board", requiredPermission="ADMIN")
    public void tentaizu(PlayerCommandEvent event) {
        if (event.getGame() != null) {
            event.getPlayer().sendAlert("Believe it or not, but /tentaizu is one of the few commands who is everything-but-server-only.");
        }
        event.getPlayer().sendChat("Param: " + event.getParameter(0));
        if (event.getParameter(0).contentEquals("new")) {
            this.newTentaizu(event.getMap(), event.getPlayer());
            event.getPlayer().sendChat("Unclicked: " + event.getMap().getAllUnclickedFields().size());
        } else if (event.getParameter(0).contentEquals("full")) {
            this.newTentaizu(event.getMap(), event.getPlayer());
            event.getPlayer().sendChat("Unclicked: " + event.getMap().getAllUnclickedFields().size());
            this.tentaizu(256, event.getMap(), event.getPlayer(), this.validOne);
        } else if (event.getParameter(0).contentEquals("simple")) {
            this.tentaizuEasier(event.getMap(), event.getParameterInt(1, 1));
        } else if (event.getParameter(0).contentEquals("random")) {
            this.newTentaizu(event.getMap(), event.getPlayer());
            event.getPlayer().sendChat("Unclicked: " + event.getMap().getAllUnclickedFields().size());
            MinesweeperMap map = event.getMap();
            Random rand = new Random();
            this.tentaizu(map.getFieldHeight() * map.getFieldWidth(), map, event.getPlayer(), new TentaizuValidatorWithX(event.getParameterInt(1, rand.nextInt(10) + 1), event.getParameterInt(2, rand.nextInt(40) + 12)));
        } else {
            int count = event.getParameterInt(0, 1);
            double time = this.tentaizu(count, event.getMap(), event.getPlayer(), this.validOne);
            event.getPlayer().sendChat(count + " iterations took " + time + " ms");
        }
    }

    private void tentaizuEasier(MinesweeperMap map, int count) {
        for (int i = 0; i < count; ++i) {
            ArrayList<MinesweeperField> fields = new ArrayList<MinesweeperField>();
            for (MinesweeperField ff : map.getIteration()) {
                if (ff.isClicked() || ff.isMine()) continue;
                fields.add(ff);
            }
            MinesweeperField field = (MinesweeperField)UtilZomisList.getRandom(fields);
            if (field == null) continue;
            field.activate();
        }
    }

    private double tentaizu(int count, MinesweeperMap map, MinesweeperPlayer player, TentaizuValidator validator) {
        long time = System.nanoTime();
        for (int i = 0; i < count; ++i) {
            logger.info((Object)("Starting iteration " + i));
            boolean b = this.tentaizuStep(map, player, validator);
            if (b) continue;
            count = i + 1;
            break;
        }
        long time2 = System.nanoTime();
        return UtilZomisUtils.nanoToMilli((long)(time2 - time));
    }

    private boolean tentaizuStep(MinesweeperMap map, MinesweeperPlayer player, TentaizuValidator validator) {
        ArrayList<MinesweeperField> fields = new ArrayList<MinesweeperField>();
        AnalyzeResult<MinesweeperField> analyze = AnalyzeFactory.analyze(map, false).getAnalyze();
        for (MinesweeperField ff : map.getIteration()) {
            if (!this.isRemovable(ff, analyze, validator)) continue;
            fields.add(ff);
        }
        int removed = 0;
        while (true) {
            MinesweeperField ff;
            ff = (MinesweeperField)UtilZomisList.getRandom(fields);
            if (player != null) {
                player.sendChat("Step " + ff + " of " + fields.size() + " possible");
            }
            if (ff == null || !this.isRemovable(ff, AnalyzeFactory.analyze(map, false).getAnalyze(), validator)) break;
            logger.info((Object)("Removing " + ff));
            fields.remove(ff);
            ff.inactivate();
            ++removed;
        }
        return removed > 0;
    }

    private boolean isRemovable(MinesweeperField ff, AnalyzeResult<MinesweeperField> before, TentaizuValidator validator) {
        if (!ff.isClicked()) {
            return false;
        }
        ff.inactivate();
        AnalyzeResult<MinesweeperField> now = AnalyzeFactory.analyze(ff.getMap(), false).getAnalyze();
        boolean valid = validator.isValid(ff, before, now);
        ff.activate();
        return valid;
    }

    private void newTentaizu(MinesweeperMap map, MinesweeperPlayer asker) {
        for (MinesweeperField ff : map.getIteration()) {
            if (ff.isMine()) continue;
            if (asker != null) {
                asker.sendChat(ff.toString());
            }
            ff.activate();
        }
    }

    private class TentaizuValidatorWithX
    implements TentaizuValidator {
        private final int maxCombinations;
        private final int desired100;

        public TentaizuValidatorWithX(int maxCombinations, int desired100) {
            logger.info((Object)("TentaizuValidatorWithX: " + maxCombinations + " combinations and 100%: " + desired100));
            this.maxCombinations = maxCombinations;
            this.desired100 = desired100;
        }

        @Override
        public boolean isValid(MinesweeperField field, AnalyzeResult<MinesweeperField> before, AnalyzeResult<MinesweeperField> analyze) {
            return analyze.getTotal() <= (double)this.maxCombinations && MineprobHelper.find100(analyze) >= this.desired100;
        }
    }

    private static interface TentaizuValidator {
        public boolean isValid(MinesweeperField var1, AnalyzeResult<MinesweeperField> var2, AnalyzeResult<MinesweeperField> var3);
    }
}

