/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.mfeais;

import java.util.List;
import net.zomis.UtilZomisList;
import net.zomis.mario.classes.Board;
import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Click;
import net.zomis.mario.classes.Enums;
import net.zomis.mario.classes.Point;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class AbstractMarioBot
extends MinesweeperAI {
    public static boolean USE_RANDOMNESS = false;
    private Bot bot;

    public Bot getBot() {
        return this.bot;
    }

    public AbstractMarioBot(MinesweeperPlayingPlayer player, Enums.Difficult difficulty) {
        super(player);
        this.bot = new Bot(player.getIndex() == 0 ? Enums.PlayerColor.BLUE : Enums.PlayerColor.RED, difficulty);
    }

    public boolean agreeDraw() {
        return false;
    }

    public MinesweeperMove play() {
        char[][] board = NightmareTools.fixBoard(this.getPlayingPlayer(), this.bot);
        try {
            List<Click> moves = this.bot.move(board);
            Click click = null;
            if (USE_RANDOMNESS) {
                click = (Click)UtilZomisList.getRandom(moves);
            } else {
                if (moves.isEmpty()) {
                    return null;
                }
                click = moves.get(0);
            }
            if (click == null) {
                MinesweeperField field = (MinesweeperField)UtilZomisList.getRandom((List)this.getMap().getAllUnclickedFields());
                return this.getPlayingPlayer().createMove("P", field);
            }
            this.sendClickInfo(click, this.bot.getBoard());
            return this.getPlayingPlayer().createMove("P", this.getMap().getPosition(click.col, click.row));
        }
        catch (Exception e) {
            this.sendChatMessage(e.getClass().getCanonicalName() + ": " + e.getMessage());
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length && i < 20; ++i) {
                this.sendChatMessage(stack[i].toString());
            }
            return null;
        }
    }

    private void sendClickInfo(Click click, Board board) {
    }

    public static void logBoards(MinesweeperAI ai, char[][] board, MinesweeperGame game) {
        ai.sendChatMessage("The board I got was:");
        for (char[] ch : board) {
            ai.sendChatMessage(new String(ch));
        }
        ai.sendChatMessage("While the real board is:");
        for (String str : ai.getMap().saveMapMultiline()) {
            ai.sendChatMessage(str);
        }
    }

    public boolean respondToInvite(Invite invite) {
        if (invite.getPlugins().size() != 1 || !((MinesweeperPlugin)invite.getPlugins().get(0)).getSimpleName().equals("PluginClassicGame")) {
            invite.getHost().sendChatBy("Sorry, but I am only able to play classic games. 1 vs 1.", this.getPlayer());
            return false;
        }
        return true;
    }

    public void respondTo(PlayerCommandEvent event) {
        if (event.getParameter(0).contentEquals("expval")) {
            int x = event.getParameterInt(1, 0);
            int y = event.getParameterInt(2, 0);
            this.sendChatMessage(String.format("First expected value of %s is %f", new Point(y, x), this.bot.getBoard().FirstExpectedValue()[y][x]));
        } else if (event.getParameter(0).contentEquals("square")) {
            int x = event.getParameterInt(1, 0);
            int y = event.getParameterInt(2, 0);
            this.sendChatMessage(this.bot.getBoard().square[y][x].toString());
        } else if (event.getParameter(0).contentEquals("maxexp")) {
            this.sendChatMessage(String.format("Max expected value is %f", this.bot.getBoard().MaxExpectedValue()));
        } else if (event.getParameter(0).contentEquals("max1exp")) {
            this.sendChatMessage(String.format("Max first expected value is %f", this.bot.getBoard().MaxFirstExpectedValue()));
        } else if (event.getParameter(0).contentEquals("minexp")) {
            this.sendChatMessage(String.format("Min expected value is %f", this.bot.getBoard().MinFirstExpectedValue()));
        } else if (event.getParameter(0).contentEquals("min1exp")) {
            this.sendChatMessage(String.format("Min first expected value is %f", this.bot.getBoard().MinFirstExpectedValue()));
        } else if (event.getParameter(0).contentEquals("tostr")) {
            this.sendChatMessage(this.bot.getBoard().toString());
        } else if (event.getParameter(0).contentEquals("analyze")) {
            char[][] board = NightmareTools.fixBoard(this.getPlayingPlayer(), this.bot);
            this.sendChatMessage("Analyzing on command.");
            for (Click click : this.bot.move(board)) {
                this.sendChatMessage("I would make this move: " + click);
            }
        } else {
            this.sendChatMessage("I don't know how to respond to that. Try with one of these: expval, square, maxexp, max1exp, minexp, min1exp, tostr, analyze");
        }
    }
}

