/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.classes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.logging.Logger;
import net.zomis.mario.classes.BoardEventHandler;
import net.zomis.mario.classes.BoardEventLogHandler;
import net.zomis.mario.classes.Configuration;
import net.zomis.mario.classes.Counter;
import net.zomis.mario.classes.Enums;
import net.zomis.mario.classes.Frequency;
import net.zomis.mario.classes.Group;
import net.zomis.mario.classes.KnownPoint;
import net.zomis.mario.classes.MinesweeperFlags;
import net.zomis.mario.classes.Permutation;
import net.zomis.mario.classes.Point;
import net.zomis.mario.classes.RandomFactory;
import net.zomis.mario.classes.Region;
import net.zomis.mario.classes.Square;
import net.zomis.mario.classes.UnknownPoint;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.mario.probability.Combinatory;
import net.zomis.minesweeper.analyze.RuntimeTimeoutException;

public class Board {
    public boolean FASTMODE;
    public static int MINES = 51;
    public static int DIMH = 16;
    public static int DIMV = 16;
    public int MAXLEVEL;
    public boolean PARETO = false;
    char[][] logicBoard;
    boolean emptyBoard;
    public Square[][] square;
    boolean[][] obviousMines;
    boolean[][] obviousNotMines;
    boolean[][] notSoObviousMines;
    boolean[][] notSoObviousNotMines;
    int obviousMinesCount;
    int obviousNotMinesCount;
    int notSoobviousMinesCount;
    int notSoobviousNotMinesCount;
    List<Group> groups;
    List<Permutation> permutations;
    List<Frequency[]> answersFrequencies;
    List<Region> regions;
    int initialMines;
    int initialRedMines;
    int initialBlueMines;
    int foundMines;
    double leftMines;
    Double maxFirstExpectedValue;
    Double minFirstExpectedValue;
    Double maxExpectedValue;
    Double minExpectedValue;
    Configuration configuration = Configuration.SolverConfig();
    int openSeaCount;
    boolean[][] openSea;
    double totalCases;
    int level;
    public boolean solved;
    boolean firstStep;
    boolean lastStep;
    public BoardEventHandler OnEvent;
    public BoardEventLogHandler OnEventLog;

    public char[][] LogicBoard() {
        return this.logicBoard;
    }

    public int[][] InitialAdjacents() {
        int[][] rtn = new int[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                rtn[i][j] = this.square[i][j].placement.value;
            }
        }
        return rtn;
    }

    public int[][] Adjacents() {
        int[][] rtn = new int[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                rtn[i][j] = this.square[i][j].adjacents;
            }
        }
        return rtn;
    }

    public double[][][] Probability() {
        double[][][] rtn = new double[DIMV][DIMH][10];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                for (int k = 0; k < 10; ++k) {
                    rtn[i][j][k] = this.square[i][j].probability[k];
                }
            }
        }
        return rtn;
    }

    public double[][][] BombProbability() {
        double[][][] bombProbability = new double[DIMV][DIMH][26];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                for (int k = 0; k <= 25; ++k) {
                    bombProbability[i][j][k] = this.square[i][j].bombProbability[k];
                }
            }
        }
        return bombProbability;
    }

    public double[][][] Payoff() {
        double[][][] rtn = new double[DIMV][DIMH][10];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                for (int k = 0; k < 10; ++k) {
                    rtn[i][j][k] = this.square[i][j].payoff[k];
                }
            }
        }
        return rtn;
    }

    public double[][] Std() {
        double[][] rtn = new double[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                rtn[i][j] = this.square[i][j].std;
            }
        }
        return rtn;
    }

    public double[][] ExpandStd(double[][] value) {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                this.square[i][j].std = value[i][j];
            }
        }
        return value;
    }

    public double[][] ExpandPayoff(double[][] value) {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (!(this.square[i][j].probability[0] > 0.0)) continue;
                this.square[i][j].payoff[0] = value[i][j];
            }
        }
        return value;
    }

    public double MaxFirstExpectedValue() {
        if (this.maxFirstExpectedValue == null) {
            return 0.0;
        }
        return this.maxFirstExpectedValue;
    }

    public double MinFirstExpectedValue() {
        return this.minFirstExpectedValue;
    }

    public double MaxExpectedValue() {
        if (this.maxExpectedValue == null) {
            return 0.0;
        }
        return this.maxExpectedValue;
    }

    public double MinExpectedValue() {
        if (this.minExpectedValue == null) {
            return 0.0;
        }
        return this.minExpectedValue;
    }

    public boolean[][] MaxFirstExpectedValuePoints() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        if (!this.lastStep) {
            this.LastStep();
        }
        double maxExpectedValue = this.maxFirstExpectedValue == null ? 0.0 : this.maxFirstExpectedValue;
        boolean[][] maxFirstExpectedValuePoints = new boolean[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].firstExpectedValue == null) continue;
                maxFirstExpectedValuePoints[i][j] = this.square[i][j].firstExpectedValue == maxExpectedValue;
            }
        }
        return maxFirstExpectedValuePoints;
    }

    public boolean[][] MinFirstExpectedValuePoints() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        if (!this.lastStep) {
            this.LastStep();
        }
        double minExpectedValue = this.minFirstExpectedValue == null ? 0.0 : this.minFirstExpectedValue;
        boolean[][] minFirstExpectedValuePoints = new boolean[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].firstExpectedValue == null) continue;
                minFirstExpectedValuePoints[i][j] = this.square[i][j].firstExpectedValue == minExpectedValue;
            }
        }
        return minFirstExpectedValuePoints;
    }

    public boolean[][] MaxExpectedValuePoints() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        if (!this.lastStep) {
            this.LastStep();
        }
        double maxExpectedValue = this.maxExpectedValue == null ? 0.0 : this.maxExpectedValue;
        boolean[][] maxSecondExpectedValuePoints = new boolean[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].expectedValue == null) continue;
                maxSecondExpectedValuePoints[i][j] = this.square[i][j].expectedValue == maxExpectedValue;
            }
        }
        return maxSecondExpectedValuePoints;
    }

    public boolean[][] BestMaxExpectedValuePoints() {
        int j;
        int i;
        boolean[][] points = new boolean[DIMV][DIMH];
        ArrayList<Square> squares = new ArrayList<Square>();
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                if (this.square[i][j].firstExpectedValue == null) continue;
                squares.add(this.square[i][j]);
            }
        }
        int cant = (int)Math.ceil((double)squares.size() * 0.2);
        double auxExpectedValue = ((Square)squares.get((int)cant)).firstExpectedValue;
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                points[i][j] = this.square[i][j].firstExpectedValue != null && this.square[i][j].firstExpectedValue >= auxExpectedValue;
            }
        }
        return points;
    }

    public Double[][] FirstExpectedValue() {
        Double[][] rtn = new Double[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                rtn[i][j] = this.square[i][j].firstExpectedValue;
            }
        }
        return rtn;
    }

    public Double[][] SecondExpectedValue() {
        Double[][] rtn = new Double[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                rtn[i][j] = this.square[i][j].expectedValue;
            }
        }
        return rtn;
    }

    public List<Point> ExpandableSquares() {
        ArrayList<Point> points = new ArrayList<Point>();
        this.LookForOpenSea();
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].adjacents != this.square[i][j].placement.value) continue;
                points.add(new Point(i, j));
            }
        }
        return points;
    }

    public Double[][][] ExpectedValues() {
        Double[][][] rtn = new Double[DIMV][DIMH][10];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                for (int k = 0; k < 10; ++k) {
                    rtn[i][j][k] = this.square[i][j].expectedValues[k];
                }
            }
        }
        return rtn;
    }

    public boolean[][] OpenSea() {
        return this.openSea;
    }

    public int openSeaCount() {
        return this.openSeaCount;
    }

    public int FoundedMines() {
        return this.foundMines;
    }

    public int InitialMines() {
        return this.initialMines;
    }

    public int BlueMines() {
        return this.initialBlueMines;
    }

    public int RedMines() {
        return this.initialRedMines;
    }

    public boolean[][] ObviousMines() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.obviousMines;
    }

    public int obviousMinesCount() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.obviousMinesCount;
    }

    public boolean[][] ObviousNotMines() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.obviousNotMines;
    }

    public int obviousNotMinesCount() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.obviousNotMinesCount;
    }

    public boolean[][] NotSoObviousMines() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.notSoObviousMines;
    }

    public int notSoobviousMinesCount() {
        int cont = 0;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (!this.notSoObviousMines[i][j]) continue;
                ++cont;
            }
        }
        this.notSoobviousMinesCount = cont;
        return cont;
    }

    public boolean[][] NotSoObviousNotMines() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.notSoObviousNotMines;
    }

    public int NotSoobviousNotMinesCount() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.notSoobviousNotMinesCount;
    }

    public List<Group> Groups() {
        if (!this.firstStep) {
            this.FirstStep();
        }
        return this.groups;
    }

    public int[][] Regions() {
        int[][] regions = new int[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                regions[i][j] = this.square[i][j].region;
            }
        }
        return regions;
    }

    private void onEvent(String description, Enums.EventType eventType) {
        if (this.OnEvent != null) {
            this.OnEvent.onEvent(this, description, eventType);
        }
    }

    private void onEvent(double progress, Enums.EventType eventType) {
        if (this.OnEvent != null) {
            this.OnEvent.onEvent(this, Double.valueOf(progress).toString(), eventType);
        }
    }

    private void onEventLog(String description, Enums.LogLevel logLevel) {
        if (this.OnEventLog != null) {
            this.OnEventLog.onEvent(this, description, logLevel);
        }
    }

    public Board() {
        this.MAXLEVEL = 1;
        this.level = 1;
        this.InitializeBoardMemory();
    }

    public Board(char[][] logicBoard) {
        this(logicBoard, 1, 1);
    }

    public Board(char[][] logicBoard, int level, int MAXLEVEL) {
        this.logicBoard = logicBoard;
        this.level = level;
        this.MAXLEVEL = MAXLEVEL;
        this.InitializeBoardMemory();
        this.InitializeLogicBoard();
    }

    void InitializeBoardMemory() {
        this.FASTMODE = this.configuration.FASTMODE;
        MINES = this.configuration.MINES;
        DIMH = this.configuration.DIMH;
        DIMV = this.configuration.DIMV;
        this.PARETO = this.configuration.PARETO;
        this.leftMines = MINES;
        this.solved = false;
        this.firstStep = false;
        this.lastStep = false;
        this.square = new Square[DIMV][DIMH];
        this.initSquares();
        this.obviousMines = new boolean[DIMV][DIMH];
        this.obviousNotMines = new boolean[DIMV][DIMH];
        this.notSoObviousMines = new boolean[DIMV][DIMH];
        this.notSoObviousNotMines = new boolean[DIMV][DIMH];
        this.openSea = new boolean[DIMV][DIMH];
        this.groups = new ArrayList<Group>(10);
        this.regions = new ArrayList<Region>(5);
        this.permutations = new ArrayList<Permutation>(10);
        this.answersFrequencies = new ArrayList<Frequency[]>(10);
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                this.square[i][j].probability = new double[10];
                this.square[i][j].payoff = new double[10];
                this.square[i][j].expectedValues = new double[10];
                this.square[i][j].bombProbability = new double[26];
                this.square[i][j].placement = i == 0 && (j == 0 || j == DIMH - 1) || i == DIMV - 1 && (j == 0 || j == DIMH - 1) ? Enums.Placement.CORNER : (i == 0 || i == DIMV - 1 || j == 0 || j == DIMH - 1 ? Enums.Placement.BORDER : Enums.Placement.CENTER);
            }
        }
    }

    private void initSquares() {
        for (int i = 0; i < this.square.length; ++i) {
            for (int j = 0; j < this.square[i].length; ++j) {
                this.square[i][j] = new Square();
            }
        }
    }

    void InitializeLogicBoard() {
        int cont = 0;
        for (int i = 0; i < DIMV; ++i) {
            block9: for (int j = 0; j < DIMH; ++j) {
                switch (this.logicBoard[i][j]) {
                    case '?': {
                        ++cont;
                        continue block9;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': {
                        this.square[i][j].value = this.logicBoard[i][j] - 48;
                        this.square[i][j].virtualValue = this.square[i][j].value;
                        this.square[i][j].mine = false;
                        continue block9;
                    }
                    case 'b': {
                        ++this.initialMines;
                        ++this.initialBlueMines;
                        this.square[i][j].mine = true;
                        continue block9;
                    }
                    case 'r': {
                        ++this.initialMines;
                        ++this.initialRedMines;
                        this.square[i][j].mine = true;
                        continue block9;
                    }
                    case 'm': {
                        ++this.initialMines;
                        this.square[i][j].mine = true;
                        continue block9;
                    }
                    case 'w': {
                        this.square[i][j].mine = false;
                        continue block9;
                    }
                }
            }
        }
        this.leftMines = MINES - this.initialMines;
        this.emptyBoard = cont == DIMH * DIMV;
    }

    public void Solve() {
        this.onEvent("Starting", Enums.EventType.INFO);
        this.FirstStep();
        this.firstStep = true;
        this.LastStep();
        this.additionalStep();
        this.solved = true;
        this.onEvent("Finished", Enums.EventType.INFO);
    }

    void FirstStep() {
        this.onEvent("size() Adjacents", Enums.EventType.INFO);
        this.CountAdjacents();
        this.onEventLog("size()Adjacents", Enums.LogLevel.TRACE);
        this.onEvent("Obvious Mines", Enums.EventType.INFO);
        this.FindObviousMines();
        this.onEventLog("Obvious Mines", Enums.LogLevel.DEBUG);
        this.onEvent("Groups", Enums.EventType.INFO);
        this.LookForGroups();
        this.onEventLog("LookForGroups", Enums.LogLevel.TRACE);
        if (this.groups.size() > 0) {
            this.onEvent("Zones", Enums.EventType.INFO);
            this.LookForZones();
            this.onEventLog("LookForZones", Enums.LogLevel.TRACE);
            this.InitializeAdjacencyArrays();
            this.onEvent("Not So Obvious Mines", Enums.EventType.INFO);
            this.FindNotSoObviousMines();
            this.foundMines += this.notSoobviousMinesCount;
            this.onEventLog("FindNotSoObviousMines", Enums.LogLevel.TRACE);
        }
        this.onEvent("First Step", Enums.EventType.DEBUG);
    }

    void InitializeAdjacencyArrays() {
        for (int i = 0; i < this.groups.size(); ++i) {
            int j;
            int maxMines = this.groups.get((int)i).maximumMines + 1;
            for (j = 0; j < this.groups.get((int)i).unknown.size(); ++j) {
                this.groups.get((int)i).unknown.get((int)j).adjacents = new int[maxMines][Math.min(maxMines, 9)];
            }
            for (j = 0; j < this.groups.get((int)i).zone.size(); ++j) {
                this.groups.get((int)i).zone.get((int)j).adjacents = new int[maxMines][Math.min(maxMines, 9)];
            }
        }
    }

    void FindObviousMines() {
        this.ObviousNot();
        this.ObviousYes();
        this.foundMines = this.obviousMinesCount;
        this.leftMines -= (double)this.obviousMinesCount;
    }

    void CountAdjacents() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].mine == null || !this.square[i][j].mine.booleanValue()) {
                    if (i != 0) {
                        if (j != 0) {
                            ++this.square[i - 1][j - 1].adjacents;
                        }
                        ++this.square[i - 1][j].adjacents;
                        if (j != DIMH - 1) {
                            ++this.square[i - 1][j + 1].adjacents;
                        }
                    }
                    if (j != 0) {
                        ++this.square[i][j - 1].adjacents;
                    }
                    if (j != DIMH - 1) {
                        ++this.square[i][j + 1].adjacents;
                    }
                    if (i != DIMV - 1) {
                        if (j != 0) {
                            ++this.square[i + 1][j - 1].adjacents;
                        }
                        ++this.square[i + 1][j].adjacents;
                        if (j != DIMH - 1) {
                            ++this.square[i + 1][j + 1].adjacents;
                        }
                    }
                } else if (this.square[i][j].mine.booleanValue()) {
                    if (i != 0) {
                        if (j != 0) {
                            ++this.square[i - 1][j - 1].adjacentMines;
                            ++this.square[i - 1][j - 1].adjacentFixedMines;
                            --this.square[i - 1][j - 1].virtualValue;
                        }
                        ++this.square[i - 1][j].adjacentMines;
                        ++this.square[i - 1][j].adjacentFixedMines;
                        --this.square[i - 1][j].virtualValue;
                        if (j != DIMH - 1) {
                            ++this.square[i - 1][j + 1].adjacentMines;
                            ++this.square[i - 1][j + 1].adjacentFixedMines;
                            --this.square[i - 1][j + 1].virtualValue;
                        }
                    }
                    if (j != 0) {
                        ++this.square[i][j - 1].adjacentMines;
                        ++this.square[i][j - 1].adjacentFixedMines;
                        --this.square[i][j - 1].virtualValue;
                    }
                    if (j != DIMH - 1) {
                        ++this.square[i][j + 1].adjacentMines;
                        ++this.square[i][j + 1].adjacentFixedMines;
                        --this.square[i][j + 1].virtualValue;
                    }
                    if (i != DIMV - 1) {
                        if (j != 0) {
                            ++this.square[i + 1][j - 1].adjacentMines;
                            ++this.square[i + 1][j - 1].adjacentFixedMines;
                            --this.square[i + 1][j - 1].virtualValue;
                        }
                        ++this.square[i + 1][j].adjacentMines;
                        ++this.square[i + 1][j].adjacentFixedMines;
                        --this.square[i + 1][j].virtualValue;
                        if (j != DIMH - 1) {
                            ++this.square[i + 1][j + 1].adjacentMines;
                            ++this.square[i + 1][j + 1].adjacentFixedMines;
                            --this.square[i + 1][j + 1].virtualValue;
                        }
                    }
                }
                if (this.square[i][j].value == null || !(this.square[i][j].value.doubleValue() > 0.0)) continue;
                if (i != DIMV - 1) {
                    if (j != 0) {
                        ++this.square[i + 1][j - 1].adjacentValues;
                    }
                    ++this.square[i + 1][j].adjacentValues;
                    if (j != DIMH - 1) {
                        ++this.square[i + 1][j + 1].adjacentValues;
                    }
                }
                if (j != 0) {
                    ++this.square[i][j - 1].adjacentValues;
                }
                if (j != DIMH - 1) {
                    ++this.square[i][j + 1].adjacentValues;
                }
                if (i == 0) continue;
                if (j != 0) {
                    ++this.square[i - 1][j - 1].adjacentValues;
                }
                ++this.square[i - 1][j].adjacentValues;
                if (j == DIMH - 1) continue;
                ++this.square[i - 1][j + 1].adjacentValues;
            }
        }
    }

    void ObviousNot() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMV; ++j) {
                if (this.square[i][j].value == null || this.square[i][j].adjacentMines == 0 || this.square[i][j].value != this.square[i][j].adjacentMines) continue;
                if (i != 0) {
                    if (j != 0) {
                        this.addObviousNotMine(i - 1, j - 1);
                    }
                    this.addObviousNotMine(i - 1, j);
                    if (j != DIMH - 1) {
                        this.addObviousNotMine(i - 1, j + 1);
                    }
                }
                if (j != 0) {
                    this.addObviousNotMine(i, j - 1);
                }
                if (j != DIMH - 1) {
                    this.addObviousNotMine(i, j + 1);
                }
                if (i == DIMV - 1) continue;
                if (j != 0) {
                    this.addObviousNotMine(i + 1, j - 1);
                }
                this.addObviousNotMine(i + 1, j);
                if (j == DIMH - 1) continue;
                this.addObviousNotMine(i + 1, j + 1);
            }
        }
    }

    boolean ObviousNot(int y, int x) {
        if (this.square[y][x].adjacents == 0) {
            return false;
        }
        if (y != 0) {
            if (x != 0) {
                this.addObviousNotMine(y - 1, x - 1);
            }
            this.addObviousNotMine(y - 1, x);
            if (x != DIMV - 1) {
                this.addObviousNotMine(y - 1, x + 1);
            }
        }
        if (x != DIMV - 1) {
            this.addObviousNotMine(y, x + 1);
        }
        if (x != 0) {
            this.addObviousNotMine(y, x - 1);
        }
        if (y != DIMH - 1) {
            if (x != 0) {
                this.addObviousNotMine(y + 1, x - 1);
            }
            this.addObviousNotMine(y + 1, x);
            if (x != DIMV - 1) {
                this.addObviousNotMine(y + 1, x + 1);
            }
        }
        return true;
    }

    boolean addObviousNotMine(int y, int x) {
        if (this.square[y][x].mine != null) {
            return false;
        }
        this.square[y][x].mine = false;
        this.obviousNotMines[y][x] = true;
        ++this.obviousNotMinesCount;
        this.DecreaseAdjacent(y, x);
        return true;
    }

    void addNotSoObviousNotMine(int i, int j) {
        this.square[i][j].mine = false;
        this.notSoObviousNotMines[i][j] = true;
        ++this.notSoobviousNotMinesCount;
        this.DecreaseAdjacent(i, j);
    }

    void ObviousYes() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].value == null || this.square[i][j].value.doubleValue() == 0.0 || this.square[i][j].adjacents == 0 || this.square[i][j].value.doubleValue() - (double)this.square[i][j].adjacentMines != (double)this.square[i][j].adjacents) continue;
                boolean flag = false;
                if (i != 0) {
                    if (j != 0) {
                        flag = this.addObviousMine(i - 1, j - 1) || flag;
                    }
                    boolean bl = flag = this.addObviousMine(i - 1, j) || flag;
                    if (j != DIMH - 1) {
                        boolean bl2 = flag = this.addObviousMine(i - 1, j + 1) || flag;
                    }
                }
                if (j != 0) {
                    boolean bl = flag = this.addObviousMine(i, j - 1) || flag;
                }
                if (j != DIMH - 1) {
                    boolean bl = flag = this.addObviousMine(i, j + 1) || flag;
                }
                if (i != DIMV - 1) {
                    if (j != 0) {
                        flag = this.addObviousMine(i + 1, j - 1) || flag;
                    }
                    flag |= this.addObviousMine(i + 1, j);
                    if (j != DIMH - 1) {
                        boolean bl = flag = this.addObviousMine(i + 1, j + 1) || flag;
                    }
                }
                if (!flag) continue;
                i = i > 3 ? i - 4 : 0;
                j = j > 4 ? j - 5 : -1;
            }
        }
    }

    boolean addObviousMine(int i, int j) {
        if (this.square[i][j].mine != null) {
            return false;
        }
        this.square[i][j].mine = true;
        this.square[i][j].probability[9] = 1.0;
        this.obviousMines[i][j] = true;
        ++this.obviousMinesCount;
        this.IncreaseAdjacentMines(i, j);
        this.DecreaseAdjacent(i, j);
        return this.CheckAdjacentValues(i, j);
    }

    void addNotSoObviousMine(int i, int j) {
        this.square[i][j].mine = true;
        this.square[i][j].probability[9] = 1.0;
        this.notSoObviousMines[i][j] = true;
        ++this.notSoobviousMinesCount;
        this.IncreaseAdjacentMines(i, j);
        this.DecreaseAdjacent(i, j);
    }

    boolean CheckAdjacentValues(int i, int j) {
        boolean flag = false;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int yy = -1; yy <= 1; ++yy) {
                if (xx == 0 && yy == 0 || !this.isOnMap(i + yy, j + xx)) continue;
                Square sq = this.square[i + yy][j + xx];
                if (sq.value == null || sq.value <= 0 || sq.value != sq.adjacentMines) continue;
                flag = this.ObviousNot(i + yy, j + xx) || flag;
            }
        }
        return flag;
    }

    public boolean isOnMap(int yy, int xx) {
        if (yy < 0) {
            return false;
        }
        if (xx < 0) {
            return false;
        }
        if (yy >= DIMV) {
            return false;
        }
        return xx < DIMH;
    }

    void IncreaseAdjacentMines(int i, int j) {
        if (i != DIMV - 1) {
            if (j != 0) {
                ++this.square[i + 1][j - 1].adjacentMines;
                --this.square[i + 1][j - 1].virtualValue;
            }
            ++this.square[i + 1][j].adjacentMines;
            --this.square[i + 1][j].virtualValue;
            if (j != DIMH - 1) {
                ++this.square[i + 1][j + 1].adjacentMines;
                --this.square[i + 1][j + 1].virtualValue;
            }
        }
        if (j != 0) {
            ++this.square[i][j - 1].adjacentMines;
            --this.square[i][j - 1].virtualValue;
        }
        if (j != DIMH - 1) {
            ++this.square[i][j + 1].adjacentMines;
            --this.square[i][j + 1].virtualValue;
        }
        if (i != 0) {
            if (j != 0) {
                ++this.square[i - 1][j - 1].adjacentMines;
                --this.square[i - 1][j - 1].virtualValue;
            }
            ++this.square[i - 1][j].adjacentMines;
            --this.square[i - 1][j].virtualValue;
            if (j != DIMH - 1) {
                ++this.square[i - 1][j + 1].adjacentMines;
                --this.square[i - 1][j + 1].virtualValue;
            }
        }
    }

    void DecreaseAdjacent(int i, int j) {
        if (i != 0) {
            if (j != 0) {
                --this.square[i - 1][j - 1].adjacents;
            }
            --this.square[i - 1][j].adjacents;
            if (j != DIMH - 1) {
                --this.square[i - 1][j + 1].adjacents;
            }
        }
        if (j != 0) {
            --this.square[i][j - 1].adjacents;
        }
        if (j != DIMH - 1) {
            --this.square[i][j + 1].adjacents;
        }
        if (i != DIMV - 1) {
            if (j != 0) {
                --this.square[i + 1][j - 1].adjacents;
            }
            --this.square[i + 1][j].adjacents;
            if (j != DIMH - 1) {
                --this.square[i + 1][j + 1].adjacents;
            }
        }
    }

    void LookForGroups() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].adjacentValues == 0 || this.square[i][j].mine != null) continue;
                Integer compare = 0;
                if (i != 0 && j != 0 && this.square[i - 1][j - 1].value != null && this.square[i - 1][j - 1].value > compare && this.square[i - 1][j - 1].inGroup == 0) {
                    this.LookForMoreUnknowns(i - 1, j - 1);
                    continue;
                }
                if (i != 0 && this.square[i - 1][j].value != null && this.square[i - 1][j].value > compare && this.square[i - 1][j].inGroup == 0) {
                    this.LookForMoreUnknowns(i - 1, j);
                    continue;
                }
                if (i != 0 && j != DIMH - 1 && this.square[i - 1][j + 1].value != null && this.square[i - 1][j + 1].value > compare && this.square[i - 1][j + 1].inGroup == 0) {
                    this.LookForMoreUnknowns(i - 1, j + 1);
                    continue;
                }
                if (j != 0 && this.square[i][j - 1].value != null && this.square[i][j - 1].value > compare && this.square[i][j - 1].inGroup == 0) {
                    this.LookForMoreUnknowns(i, j - 1);
                    continue;
                }
                if (j != DIMH - 1 && this.square[i][j + 1].value != null && this.square[i][j + 1].value > compare && this.square[i][j + 1].inGroup == 0) {
                    this.LookForMoreUnknowns(i, j + 1);
                    continue;
                }
                if (i != DIMV - 1 && j != 0 && this.square[i + 1][j - 1].value != null && this.square[i + 1][j - 1].value > compare && this.square[i + 1][j - 1].inGroup == 0) {
                    this.LookForMoreUnknowns(i + 1, j - 1);
                    continue;
                }
                if (i != DIMV - 1 && this.square[i + 1][j].value != null && this.square[i + 1][j].value > compare && this.square[i + 1][j].inGroup == 0) {
                    this.LookForMoreUnknowns(i + 1, j);
                    continue;
                }
                if (i == DIMV - 1 || j == DIMH - 1 || this.square[i + 1][j + 1].value == null || this.square[i + 1][j + 1].value <= compare || this.square[i + 1][j + 1].inGroup != 0) continue;
                this.LookForMoreUnknowns(i + 1, j + 1);
            }
        }
    }

    void LookForMoreUnknowns(int row, int col) {
        int knownIndex = 0;
        Group group = new Group();
        group.known.add(new KnownPoint(row, col));
        do {
            UnknownPoint tempUnknownPoint;
            this.square[row][col].inGroup = this.groups.size() + 1;
            if (row != 0) {
                if (col != 0 && this.square[row - 1][col - 1].value == null && this.square[row - 1][col - 1].adjacentValues > 0 && this.square[row - 1][col - 1].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row - 1, col - 1, knownIndex);
                    if (this.square[row - 1][col - 1].inGroup == 0) {
                        this.square[row - 1][col - 1].inGroup = this.groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        this.LookForMoreValues(group, row - 1, col - 1);
                    } else {
                        group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
                if (this.square[row - 1][col].value == null && this.square[row - 1][col].adjacentValues > 0 && this.square[row - 1][col].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row - 1, col, knownIndex);
                    if (this.square[row - 1][col].inGroup == 0) {
                        this.square[row - 1][col].inGroup = this.groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        this.LookForMoreValues(group, row - 1, col);
                    } else {
                        group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
                if (col < DIMH - 1 && this.square[row - 1][col + 1].value == null && this.square[row - 1][col + 1].adjacentValues > 0 && this.square[row - 1][col + 1].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row - 1, col + 1, knownIndex);
                    if (this.square[row - 1][col + 1].inGroup == 0) {
                        this.square[row - 1][col + 1].inGroup = this.groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        this.LookForMoreValues(group, row - 1, col + 1);
                    } else {
                        group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
            }
            if (row != DIMV - 1) {
                if (col != 0 && this.square[row + 1][col - 1].value == null && this.square[row + 1][col - 1].adjacentValues > 0 && this.square[row + 1][col - 1].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row + 1, col - 1, knownIndex);
                    if (this.square[row + 1][col - 1].inGroup == 0) {
                        this.square[row + 1][col - 1].inGroup = this.groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        this.LookForMoreValues(group, row + 1, col - 1);
                    } else {
                        group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
                if (this.square[row + 1][col].value == null && this.square[row + 1][col].adjacentValues > 0 && this.square[row + 1][col].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row + 1, col, knownIndex);
                    if (this.square[row + 1][col].inGroup == 0) {
                        this.square[row + 1][col].inGroup = this.groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        this.LookForMoreValues(group, row + 1, col);
                    } else {
                        group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
                if (col != DIMH - 1 && this.square[row + 1][col + 1].value == null && this.square[row + 1][col + 1].adjacentValues > 0 && this.square[row + 1][col + 1].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row + 1, col + 1, knownIndex);
                    if (this.square[row + 1][col + 1].inGroup == 0) {
                        this.square[row + 1][col + 1].inGroup = this.groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        this.LookForMoreValues(group, row + 1, col + 1);
                    } else {
                        group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
            }
            if (col != 0 && this.square[row][col - 1].value == null && this.square[row][col - 1].adjacentValues > 0 && this.square[row][col - 1].mine == null) {
                tempUnknownPoint = new UnknownPoint(row, col - 1, knownIndex);
                if (this.square[row][col - 1].inGroup == 0) {
                    this.square[row][col - 1].inGroup = this.groups.size() + 1;
                    group.unknown.add(tempUnknownPoint);
                    this.LookForMoreValues(group, row, col - 1);
                } else {
                    group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                }
            }
            if (col != DIMH - 1 && this.square[row][col + 1].value == null && this.square[row][col + 1].adjacentValues > 0 && this.square[row][col + 1].mine == null) {
                tempUnknownPoint = new UnknownPoint(row, col + 1, knownIndex);
                if (this.square[row][col + 1].inGroup == 0) {
                    this.square[row][col + 1].inGroup = this.groups.size() + 1;
                    group.unknown.add(tempUnknownPoint);
                    this.LookForMoreValues(group, row, col + 1);
                } else {
                    group.unknown.get((int)group.unknown.indexOf((Object)tempUnknownPoint)).relKnown.add(knownIndex);
                }
            }
            if (++knownIndex >= group.known.size()) continue;
            row = group.known.get((int)knownIndex).row;
            col = group.known.get((int)knownIndex).col;
        } while (knownIndex < group.known.size());
        this.CalculateMaximumMines(group);
        this.groups.add(group);
    }

    void CalculateMaximumMines(Group group) {
        int valuesSum = 0;
        for (int i = 0; i < group.known.size(); ++i) {
            valuesSum = (int)((double)valuesSum + this.square[group.known.get((int)i).row][group.known.get((int)i).col].value.doubleValue());
        }
        group.maximumMines = valuesSum < group.unknown.size() ? valuesSum : group.unknown.size();
    }

    void LookForMoreValues(Group group, int row, int col) {
        if (row != 0) {
            if (col != 0 && this.square[row - 1][col - 1].value != null && this.square[row - 1][col - 1].value > 0 && this.square[row - 1][col - 1].inGroup == 0) {
                this.square[row - 1][col - 1].inGroup = this.groups.size() + 1;
                group.known.add(new KnownPoint(row - 1, col - 1));
            }
            if (this.square[row - 1][col].value != null && this.square[row - 1][col].value > 0 && this.square[row - 1][col].inGroup == 0) {
                this.square[row - 1][col].inGroup = this.groups.size() + 1;
                group.known.add(new KnownPoint(row - 1, col));
            }
            if (col != DIMH - 1 && this.square[row - 1][col + 1].value != null && this.square[row - 1][col + 1].value > 0 && this.square[row - 1][col + 1].inGroup == 0) {
                this.square[row - 1][col + 1].inGroup = this.groups.size() + 1;
                group.known.add(new KnownPoint(row - 1, col + 1));
            }
        }
        if (row != DIMV - 1) {
            if (col != 0 && this.square[row + 1][col - 1].value != null && this.square[row + 1][col - 1].value > 0 && this.square[row + 1][col - 1].inGroup == 0) {
                this.square[row + 1][col - 1].inGroup = this.groups.size() + 1;
                group.known.add(new KnownPoint(row + 1, col - 1));
            }
            if (this.square[row + 1][col].value != null && this.square[row + 1][col].value > 0 && this.square[row + 1][col].inGroup == 0) {
                this.square[row + 1][col].inGroup = this.groups.size() + 1;
                group.known.add(new KnownPoint(row + 1, col));
            }
            if (col != DIMH - 1 && this.square[row + 1][col + 1].value != null && this.square[row + 1][col + 1].value > 0 && this.square[row + 1][col + 1].inGroup == 0) {
                this.square[row + 1][col + 1].inGroup = this.groups.size() + 1;
                group.known.add(new KnownPoint(row + 1, col + 1));
            }
        }
        if (col != 0 && this.square[row][col - 1].value != null && this.square[row][col - 1].value > 0 && this.square[row][col - 1].inGroup == 0) {
            this.square[row][col - 1].inGroup = this.groups.size() + 1;
            group.known.add(new KnownPoint(row, col - 1));
        }
        if (col != DIMH - 1 && this.square[row][col + 1].value != null && this.square[row][col + 1].value > 0 && this.square[row][col + 1].inGroup == 0) {
            this.square[row][col + 1].inGroup = this.groups.size() + 1;
            group.known.add(new KnownPoint(row, col + 1));
        }
    }

    void LookForZones() {
        for (int i = 0; i < this.groups.size(); ++i) {
            for (int j = 0; j < this.groups.get((int)i).unknown.size(); ++j) {
                int tmpIndex;
                MinesweeperFlags.ZonePoint tmpPoint;
                int row = this.groups.get((int)i).unknown.get((int)j).row;
                int col = this.groups.get((int)i).unknown.get((int)j).col;
                if (this.square[row][col].mine != null) continue;
                if (row != DIMV - 1) {
                    if (col != DIMH - 1 && this.square[row + 1][col + 1].mine != Boolean.TRUE) {
                        if (this.square[row + 1][col + 1].inGroup != i + 1) {
                            MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                            minesweeperFlags.getClass();
                            tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row + 1, col + 1);
                            if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                this.square[row + 1][col + 1].inZone = true;
                                this.groups.get((int)i).zone.add(tmpPoint);
                            }
                            tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                            this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(row + 1, col + 1));
                            if (tmpIndex != -1) {
                                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                    if (col != 0) {
                        MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                        minesweeperFlags.getClass();
                        tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row + 1, col - 1);
                        if (this.square[row + 1][col - 1].mine != Boolean.TRUE) {
                            if (this.square[row + 1][col - 1].inGroup != i + 1) {
                                if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                    this.square[row + 1][col - 1].inZone = true;
                                    this.groups.get((int)i).zone.add(tmpPoint);
                                }
                                tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                                this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                            } else {
                                tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                                if (tmpIndex != -1) {
                                    this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                                }
                            }
                        }
                    }
                    MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                    minesweeperFlags.getClass();
                    tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row + 1, col);
                    if (this.square[row + 1][col].mine != Boolean.TRUE) {
                        if (this.square[row + 1][col].inGroup != i + 1) {
                            if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                this.square[row + 1][col].inZone = true;
                                this.groups.get((int)i).zone.add(tmpPoint);
                            }
                            tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                            this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
                if (col != DIMH - 1) {
                    MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                    minesweeperFlags.getClass();
                    tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row, col + 1);
                    if (this.square[row][col + 1].mine != Boolean.TRUE) {
                        if (this.square[row][col + 1].inGroup != i + 1) {
                            if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                this.square[row][col + 1].inZone = true;
                                this.groups.get((int)i).zone.add(tmpPoint);
                            }
                            tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                            this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
                if (col != 0) {
                    MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                    minesweeperFlags.getClass();
                    tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row, col - 1);
                    if (this.square[row][col - 1].mine != Boolean.TRUE) {
                        if (this.square[row][col - 1].inGroup != i + 1) {
                            if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                this.square[row][col - 1].inZone = true;
                                this.groups.get((int)i).zone.add(tmpPoint);
                            }
                            tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                            this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
                if (row == 0) continue;
                if (col != DIMH - 1) {
                    MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                    minesweeperFlags.getClass();
                    tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row - 1, col + 1);
                    if (this.square[row - 1][col + 1].mine != Boolean.TRUE) {
                        if (this.square[row - 1][col + 1].inGroup != i + 1) {
                            if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                this.square[row - 1][col + 1].inZone = true;
                                this.groups.get((int)i).zone.add(tmpPoint);
                            }
                            tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                            this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
                if (col != 0) {
                    MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                    minesweeperFlags.getClass();
                    tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row - 1, col - 1);
                    if (this.square[row - 1][col - 1].mine != Boolean.TRUE) {
                        if (this.square[row - 1][col - 1].inGroup != i + 1) {
                            if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                                this.square[row - 1][col - 1].inZone = true;
                                this.groups.get((int)i).zone.add(tmpPoint);
                            }
                            tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                            this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
                MinesweeperFlags minesweeperFlags = new MinesweeperFlags();
                minesweeperFlags.getClass();
                tmpPoint = new MinesweeperFlags.ZonePoint(minesweeperFlags, row - 1, col);
                if (this.square[row - 1][col].mine == Boolean.TRUE) continue;
                if (this.square[row - 1][col].inGroup != i + 1) {
                    if (!this.groups.get((int)i).zone.contains(tmpPoint)) {
                        this.square[row - 1][col].inZone = true;
                        this.groups.get((int)i).zone.add(tmpPoint);
                    }
                    tmpIndex = this.groups.get((int)i).zone.indexOf(tmpPoint);
                    this.groups.get((int)i).unknown.get((int)j).relZone.add(tmpIndex);
                    continue;
                }
                tmpIndex = this.groups.get((int)i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                if (tmpIndex == -1) continue;
                this.groups.get((int)i).unknown.get((int)j).relUnknown.add(tmpIndex);
            }
        }
    }

    void FindNotSoObviousMines() {
        for (int i = 0; i < this.groups.size(); ++i) {
            int row = this.groups.get((int)i).known.get((int)0).row;
            int col = this.groups.get((int)i).known.get((int)0).col;
            if (this.square[row][col].value < this.square[row][col].adjacentMines) {
                this.onEvent("Error @ FindNotSoObviousMines (" + row + ", " + col + ")", Enums.EventType.ERROR);
                return;
            }
            this.MinesAssignment(i, 0, Integer.valueOf(this.square[row][col].value - this.square[row][col].adjacentMines).byteValue());
            if (this.groups.get((int)i).answers.size() > 0) {
                for (int j = 0; j < this.groups.get((int)i).unknown.size(); ++j) {
                    if (this.groups.get((int)i).unknown.get(j).TotalTimes() == this.groups.get((int)i).answers.size()) {
                        this.addNotSoObviousMine(this.groups.get((int)i).unknown.get((int)j).row, this.groups.get((int)i).unknown.get((int)j).col);
                        continue;
                    }
                    if (this.groups.get((int)i).unknown.get(j).TotalTimes() != 0) continue;
                    this.addNotSoObviousNotMine(this.groups.get((int)i).unknown.get((int)j).row, this.groups.get((int)i).unknown.get((int)j).col);
                }
                continue;
            }
            this.onEvent("Impossible Board (Not answers for group " + i + ")", Enums.EventType.ERROR);
            return;
        }
    }

    void MinesAssignment(int groupIndex, int knownIndex, int mines) {
        boolean flag = false;
        int ini = 0;
        int cantLevel = 0;
        for (int i = 0; i < this.groups.get((int)groupIndex).unknown.size(); ++i) {
            if (this.groups.get((int)groupIndex).unknown.get((int)i).relKnown.get(0) == knownIndex) {
                if (!flag) {
                    ini = i;
                    flag = true;
                }
                ++cantLevel;
                continue;
            }
            if (flag) break;
        }
        if (!flag) {
            return;
        }
        switch (mines) {
            case 1: {
                for (int i1 = ini; i1 < ini + cantLevel; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    this.IsValidAnswer(groupIndex, knownIndex + 1);
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
            case 2: {
                for (int i1 = ini; i1 < ini + cantLevel - 1; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    for (int i2 = i1 + 1; i2 < ini + cantLevel; ++i2) {
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = true;
                        this.IsValidAnswer(groupIndex, knownIndex + 1);
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = false;
                    }
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
            case 3: {
                for (int i1 = ini; i1 < ini + cantLevel - 2; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    for (int i2 = i1 + 1; i2 < ini + cantLevel - 1; ++i2) {
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = true;
                        for (int i3 = i2 + 1; i3 < ini + cantLevel; ++i3) {
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = true;
                            this.IsValidAnswer(groupIndex, knownIndex + 1);
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = false;
                        }
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = false;
                    }
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
            case 4: {
                for (int i1 = ini; i1 < ini + cantLevel - 3; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    for (int i2 = i1 + 1; i2 < ini + cantLevel - 2; ++i2) {
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = true;
                        for (int i3 = i2 + 1; i3 < ini + cantLevel - 1; ++i3) {
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = true;
                            for (int i4 = i3 + 1; i4 < ini + cantLevel; ++i4) {
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = true;
                                this.IsValidAnswer(groupIndex, knownIndex + 1);
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = false;
                            }
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = false;
                        }
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = false;
                    }
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
            case 5: {
                for (int i1 = ini; i1 < ini + cantLevel - 4; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    for (int i2 = i1 + 1; i2 < ini + cantLevel - 3; ++i2) {
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = true;
                        for (int i3 = i2 + 1; i3 < ini + cantLevel - 2; ++i3) {
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = true;
                            for (int i4 = i3 + 1; i4 < ini + cantLevel - 1; ++i4) {
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = true;
                                for (int i5 = i4 + 1; i5 < ini + cantLevel; ++i5) {
                                    this.groups.get((int)groupIndex).unknown.get((int)i5).tempMine = true;
                                    this.IsValidAnswer(groupIndex, knownIndex + 1);
                                    this.groups.get((int)groupIndex).unknown.get((int)i5).tempMine = false;
                                }
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = false;
                            }
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = false;
                        }
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = false;
                    }
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
            case 6: {
                for (int i1 = ini; i1 < ini + cantLevel - 5; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    for (int i2 = i1 + 1; i2 < ini + cantLevel - 4; ++i2) {
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = true;
                        for (int i3 = i2 + 1; i3 < ini + cantLevel - 3; ++i3) {
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = true;
                            for (int i4 = i3 + 1; i4 < ini + cantLevel - 2; ++i4) {
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = true;
                                for (int i5 = i4 + 1; i5 < ini + cantLevel - 1; ++i5) {
                                    this.groups.get((int)groupIndex).unknown.get((int)i5).tempMine = true;
                                    for (int i6 = i5 + 1; i6 < ini + cantLevel; ++i6) {
                                        this.groups.get((int)groupIndex).unknown.get((int)i6).tempMine = true;
                                        this.IsValidAnswer(groupIndex, knownIndex + 1);
                                        this.groups.get((int)groupIndex).unknown.get((int)i6).tempMine = false;
                                    }
                                    this.groups.get((int)groupIndex).unknown.get((int)i5).tempMine = false;
                                }
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = false;
                            }
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = false;
                        }
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = false;
                    }
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
            case 7: {
                for (int i1 = ini; i1 < ini + cantLevel - 6; ++i1) {
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = true;
                    for (int i2 = i1 + 1; i2 < ini + cantLevel - 5; ++i2) {
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = true;
                        for (int i3 = i2 + 1; i3 < ini + cantLevel - 4; ++i3) {
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = true;
                            for (int i4 = i3 + 1; i4 < ini + cantLevel - 3; ++i4) {
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = true;
                                for (int i5 = i4 + 1; i5 < ini + cantLevel - 2; ++i5) {
                                    this.groups.get((int)groupIndex).unknown.get((int)i5).tempMine = true;
                                    for (int i6 = i5 + 1; i6 < ini + cantLevel - 1; ++i6) {
                                        this.groups.get((int)groupIndex).unknown.get((int)i6).tempMine = true;
                                        for (int i7 = i6 + 1; i7 < ini + cantLevel; ++i7) {
                                            this.groups.get((int)groupIndex).unknown.get((int)i7).tempMine = true;
                                            this.IsValidAnswer(groupIndex, knownIndex + 1);
                                            this.groups.get((int)groupIndex).unknown.get((int)i7).tempMine = false;
                                        }
                                        this.groups.get((int)groupIndex).unknown.get((int)i6).tempMine = false;
                                    }
                                    this.groups.get((int)groupIndex).unknown.get((int)i5).tempMine = false;
                                }
                                this.groups.get((int)groupIndex).unknown.get((int)i4).tempMine = false;
                            }
                            this.groups.get((int)groupIndex).unknown.get((int)i3).tempMine = false;
                        }
                        this.groups.get((int)groupIndex).unknown.get((int)i2).tempMine = false;
                    }
                    this.groups.get((int)groupIndex).unknown.get((int)i1).tempMine = false;
                }
                break;
            }
        }
    }

    void IsValidAnswer(int groupIndex, int knownIndex) {
        if (Thread.interrupted()) {
            throw new RuntimeTimeoutException();
        }
        if (knownIndex == this.groups.get((int)groupIndex).known.size()) {
            this.addAnswer(groupIndex);
        } else {
            this.CountAdjacentsTempMines(groupIndex);
            int row = this.groups.get((int)groupIndex).known.get((int)knownIndex).row;
            int col = this.groups.get((int)groupIndex).known.get((int)knownIndex).col;
            int mines = this.square[row][col].value - this.groups.get((int)groupIndex).known.get((int)knownIndex).tempMines - this.square[row][col].adjacentMines;
            if (mines == 0 && knownIndex == this.groups.get((int)groupIndex).known.size() - 1) {
                this.addAnswer(groupIndex);
            } else if (mines == 0 && knownIndex != this.groups.get((int)groupIndex).known.size() - 1) {
                do {
                    row = this.groups.get((int)groupIndex).known.get((int)(++knownIndex)).row;
                    col = this.groups.get((int)groupIndex).known.get((int)knownIndex).col;
                } while ((mines = this.square[row][col].value - this.groups.get((int)groupIndex).known.get((int)knownIndex).tempMines - this.square[row][col].adjacentMines) == 0 && knownIndex != this.groups.get((int)groupIndex).known.size() - 1);
                if (mines == 0 && knownIndex == this.groups.get((int)groupIndex).known.size() - 1 || knownIndex == this.groups.get((int)groupIndex).known.size()) {
                    this.addAnswer(groupIndex);
                }
            }
            if (mines > 0) {
                this.MinesAssignment(groupIndex, knownIndex, mines);
            }
        }
    }

    void CountAdjacentsTempMines(int groupIndex) {
        int i;
        int n1 = this.groups.get((int)groupIndex).known.size();
        for (i = 0; i < n1; ++i) {
            this.groups.get((int)groupIndex).known.get((int)i).tempMines = 0;
        }
        n1 = this.groups.get((int)groupIndex).unknown.size();
        for (i = 0; i < n1; ++i) {
            if (!this.groups.get((int)groupIndex).unknown.get((int)i).tempMine) continue;
            int n2 = this.groups.get((int)groupIndex).unknown.get((int)i).relKnown.size();
            for (int j = 0; j < n2; ++j) {
                ++this.groups.get((int)groupIndex).known.get((int)this.groups.get((int)groupIndex).unknown.get((int)i).relKnown.get((int)j).intValue()).tempMines;
            }
        }
    }

    void addAnswer(int groupIndex) {
        int i;
        Group group = this.groups.get(groupIndex);
        boolean[] tmpAnswer = new boolean[group.unknown.size()];
        int contMines = 0;
        for (i = 0; i < group.unknown.size(); ++i) {
            if (!this.groups.get((int)groupIndex).unknown.get((int)i).tempMine) continue;
            ++contMines;
        }
        for (i = 0; i < group.zone.size(); ++i) {
            group.zone.get((int)i).adjacentTempMines = 0;
        }
        for (i = 0; i < group.unknown.size(); ++i) {
            group.unknown.get((int)i).adjacentTempMines = 0;
        }
        if ((double)contMines <= this.leftMines) {
            int adjacentTempMines;
            for (i = 0; i < group.unknown.size(); ++i) {
                int tmpIndex;
                int j;
                UnknownPoint unknown = this.groups.get((int)groupIndex).unknown.get(i);
                if (!unknown.tempMine) continue;
                tmpAnswer[i] = true;
                if (unknown.times.containsKey(contMines)) {
                    unknown.times.put(contMines, unknown.times.get(contMines) + 1);
                } else {
                    unknown.times.put(contMines, 1);
                }
                for (j = 0; j < unknown.relUnknown.size(); ++j) {
                    tmpIndex = unknown.relUnknown.get(j);
                    ++group.unknown.get((int)tmpIndex).adjacentTempMines;
                }
                for (j = 0; j < unknown.relZone.size(); ++j) {
                    tmpIndex = unknown.relZone.get(j);
                    ++group.zone.get((int)tmpIndex).adjacentTempMines;
                }
            }
            for (i = 0; i < group.unknown.size(); ++i) {
                if (group.unknown.get((int)i).tempMine) continue;
                adjacentTempMines = group.unknown.get((int)i).adjacentTempMines;
                int[] nArray = group.unknown.get((int)i).adjacents[contMines];
                int n = adjacentTempMines;
                nArray[n] = nArray[n] + 1;
            }
            for (i = 0; i < group.zone.size(); ++i) {
                adjacentTempMines = group.zone.get((int)i).adjacentTempMines;
                int[] nArray = group.zone.get((int)i).adjacents[contMines];
                int n = adjacentTempMines;
                nArray[n] = nArray[n] + 1;
            }
            group.answers.add(tmpAnswer);
            group.answersCount.add(contMines);
        }
    }

    void LastStep() {
        if (this.groups.size() > 0) {
            this.onEvent("Calculate Frequencies", Enums.EventType.INFO);
            this.CalculateFrequencies();
            this.onEventLog("CalculateFrequencies", Enums.LogLevel.TRACE);
            this.PermutateFrequencies();
            this.onEventLog("PermutateFrequencies", Enums.LogLevel.TRACE);
        }
        this.onEvent("Open Sea", Enums.EventType.INFO);
        this.LookForOpenSea();
        this.onEventLog("LookForOpenSea", Enums.LogLevel.TRACE);
        this.onEvent("Frequencies", Enums.EventType.INFO);
        this.CalculatePermutationProbabilityAndLeftMines();
        this.onEventLog("CalculatePermutationProbabilityAndLeftMines", Enums.LogLevel.TRACE);
        this.CalculateFrequenciesProbability();
        this.onEventLog("CalculateFrequenciesProbability", Enums.LogLevel.TRACE);
        this.onEvent("Probability in Open Sea", Enums.EventType.INFO);
        this.CalculateProbabilityInOpenSea();
        this.onEventLog("CalculateProbabilityInOpenSea", Enums.LogLevel.TRACE);
        this.onEvent("Probability in Groups", Enums.EventType.INFO);
        this.CalculateProbabilityInGroups();
        this.onEventLog("CalculateProbabilityInGroups", Enums.LogLevel.TRACE);
        this.onEvent("Regions", Enums.EventType.INFO);
        this.CalculateRegions();
        this.onEventLog("CalculateRegions", Enums.LogLevel.TRACE);
        this.UpdateLogicBoard();
        if (this.level < this.MAXLEVEL) {
            this.onEvent("Next Level", Enums.EventType.INFO);
            this.ProcessSecondExpectedValue();
            this.onEvent("FirstExpectedValue", Enums.EventType.INFO);
            this.CalculateFirstExpectedValue();
            this.onEvent("SecondExpectedValue", Enums.EventType.INFO);
            this.CalculateExpectedValue();
        } else {
            this.onEvent("Payoffs", Enums.EventType.INFO);
            this.CalculateSecurePayoff();
            if (this.FASTMODE) {
                this.CalculateFastPayoff();
                this.CalculateGroupsPayoff();
                this.CalculateZonePayoff();
            } else {
                this.CalculatePayoff();
            }
            this.onEvent("FirstExpectedValue", Enums.EventType.INFO);
            this.CalculateFirstExpectedValue();
        }
        this.lastStep = true;
        this.onEventLog("Last Step", Enums.LogLevel.DEBUG);
    }

    void CalculateFrequencies() {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.answersFrequencies.add(this.groups.get(i).Frequency());
        }
    }

    void PermutateFrequencies() {
        this.PermutateFrequencies(new Permutation(), 0);
    }

    void PermutateFrequencies(Permutation permutation, int index) {
        for (int i = 0; i < this.answersFrequencies.get(index).length; ++i) {
            Frequency frequency = this.answersFrequencies.get(index)[i];
            if (frequency.times == 0) continue;
            permutation.groupIndex.add(i);
            permutation.nPermutation *= (double)frequency.times;
            if (index == this.answersFrequencies.size() - 1) {
                this.permutations.add(new Permutation(permutation));
                this.totalCases += permutation.nPermutation;
            } else {
                this.PermutateFrequencies(permutation, index + 1);
            }
            permutation.nPermutation /= (double)frequency.times;
            permutation.groupIndex.remove(permutation.groupIndex.size() - 1);
        }
    }

    void LookForOpenSea() {
        this.openSeaCount = 0;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].mine != null || this.square[i][j].inGroup != 0) continue;
                this.addOpenSeaSquare(i, j);
            }
        }
    }

    public void addOpenSeaSquare(int i, int j) {
        ++this.openSeaCount;
        this.openSea[i][j] = true;
        if (i != DIMV - 1) {
            if (j != DIMH - 1) {
                ++this.square[i + 1][j + 1].adjacentsOpenSea;
            }
            if (j != 0) {
                ++this.square[i + 1][j - 1].adjacentsOpenSea;
            }
            ++this.square[i + 1][j].adjacentsOpenSea;
        }
        if (j != DIMH - 1) {
            ++this.square[i][j + 1].adjacentsOpenSea;
        }
        if (j != 0) {
            ++this.square[i][j - 1].adjacentsOpenSea;
        }
        if (i != 0) {
            if (j != DIMH - 1) {
                ++this.square[i - 1][j + 1].adjacentsOpenSea;
            }
            if (j != 0) {
                ++this.square[i - 1][j - 1].adjacentsOpenSea;
            }
            ++this.square[i - 1][j].adjacentsOpenSea;
        }
    }

    void CalculatePermutationProbabilityAndLeftMines() {
        int i;
        double total = 0.0;
        for (i = 0; i < this.permutations.size(); ++i) {
            this.permutations.get((int)i).nPermutation *= Combinatory.BinomialCoefficient((int)this.leftMines - this.permutations.get((int)i).mines, this.openSeaCount);
            total += this.permutations.get((int)i).nPermutation;
        }
        for (i = 0; i < this.permutations.size(); ++i) {
            this.permutations.get((int)i).probability = this.permutations.get((int)i).nPermutation / total;
            this.leftMines -= this.permutations.get((int)i).probability * (double)this.permutations.get((int)i).mines;
        }
    }

    void CalculateFrequenciesProbability() {
        for (int i = 0; i < this.groups.size(); ++i) {
            for (int j = 0; j < this.groups.get(i).Frequency().length; ++j) {
                for (Permutation permutation : this.permutations) {
                    if (permutation.groupIndex.get(i) != j) continue;
                    Frequency freq = this.groups.get(i).Frequency()[j];
                    freq.setProbability(freq.getProbability() + permutation.probability);
                }
            }
        }
    }

    void CalculateProbabilityInOpenSea() {
        if (this.openSeaCount == 0) {
            return;
        }
        double openSeaProbability = this.leftMines / (double)this.openSeaCount;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                int k;
                if (this.openSea[i][j]) {
                    this.square[i][j].probability[9] = openSeaProbability;
                    for (k = 0; k <= this.square[i][j].adjacentsOpenSea && (double)k <= this.leftMines; ++k) {
                        this.square[i][j].probability[k + this.square[i][j].adjacentMines] = Combinatory.HypergeometricDistributionVariation(k, this.square[i][j].adjacentsOpenSea, (int)this.leftMines, this.openSeaCount);
                    }
                    continue;
                }
                if (this.square[i][j].mine == Boolean.TRUE) continue;
                for (k = 0; k <= this.square[i][j].adjacentsOpenSea && (double)k <= this.leftMines; ++k) {
                    this.square[i][j].probability[k + this.square[i][j].adjacentMines] = Combinatory.HypergeometricDistribution(k, this.square[i][j].adjacentsOpenSea, (int)this.leftMines, this.openSeaCount);
                }
            }
        }
    }

    void CalculateProbabilityInGroups() {
        for (int i = 0; i < this.groups.size(); ++i) {
            int l;
            double[] tmpProbability;
            int k;
            int col;
            int row;
            int j;
            for (j = 0; j < this.groups.get((int)i).unknown.size(); ++j) {
                row = this.groups.get((int)i).unknown.get((int)j).row;
                col = this.groups.get((int)i).unknown.get((int)j).col;
                if (this.square[row][col].probability[9] != 1.0) {
                    for (k = 0; k < this.groups.get(i).Frequency().length; ++k) {
                        Integer tmpM = this.groups.get((int)i).unknown.get((int)j).times.get(k);
                        if (tmpM == null) {
                            tmpM = 0;
                            continue;
                        }
                        this.square[row][col].probability[9] = this.square[row][col].probability[9] + (double)tmpM.intValue() * this.groups.get((int)i).Frequency()[k].div;
                    }
                }
                tmpProbability = new double[9];
                for (k = 1; k < this.groups.get((int)i).unknown.get((int)j).adjacents.length; ++k) {
                    for (l = this.square[row][col].adjacentMines - this.square[row][col].adjacentFixedMines; l < this.groups.get((int)i).unknown.get((int)j).adjacents[0].length; ++l) {
                        if (this.groups.get((int)i).unknown.get((int)j).adjacents[k][l] == 0) continue;
                        int n = l - (this.square[row][col].adjacentMines - this.square[row][col].adjacentFixedMines);
                        tmpProbability[n] = tmpProbability[n] + (double)this.groups.get((int)i).unknown.get((int)j).adjacents[k][l] * this.groups.get((int)i).Frequency()[k].div;
                    }
                }
                for (k = 8; k >= 0; --k) {
                    this.square[row][col].probability[k] = this.square[row][col].probability[k] * tmpProbability[0];
                    for (l = 1; l <= k; ++l) {
                        int n = k;
                        this.square[row][col].probability[n] = this.square[row][col].probability[n] + this.square[row][col].probability[k - l] * tmpProbability[l];
                    }
                }
            }
            for (j = 0; j < this.groups.get((int)i).zone.size(); ++j) {
                row = this.groups.get((int)i).zone.get((int)j).row;
                col = this.groups.get((int)i).zone.get((int)j).col;
                tmpProbability = new double[9];
                for (k = 1; k < this.groups.get((int)i).zone.get((int)j).adjacents.length; ++k) {
                    for (l = this.square[row][col].adjacentMines - this.square[row][col].adjacentFixedMines; l < this.groups.get((int)i).zone.get((int)j).adjacents[0].length; ++l) {
                        if (this.groups.get((int)i).zone.get((int)j).adjacents[k][l] == 0) continue;
                        int n = l - (this.square[row][col].adjacentMines - this.square[row][col].adjacentFixedMines);
                        tmpProbability[n] = tmpProbability[n] + (double)this.groups.get((int)i).zone.get((int)j).adjacents[k][l] * this.groups.get((int)i).Frequency()[k].div;
                    }
                }
                for (k = 8; k >= 0; --k) {
                    this.square[row][col].probability[k] = this.square[row][col].probability[k] * tmpProbability[0];
                    for (l = 1; l <= k; ++l) {
                        int n = k;
                        this.square[row][col].probability[n] = this.square[row][col].probability[n] + this.square[row][col].probability[k - l] * tmpProbability[l];
                    }
                }
            }
        }
    }

    void CalculateRegions() {
        int id = 1;
        for (int yy = 0; yy < DIMV; ++yy) {
            for (int xx = 0; xx < DIMH; ++xx) {
                if (this.square[yy][xx].value != null || this.square[yy][xx].region != 0 || this.square[yy][xx].mine == Boolean.TRUE) continue;
                this.LookForRegion(yy, xx, id++);
            }
        }
    }

    void LookForRegion(int i, int j, int id) {
        Region region = new Region();
        region.squaresCount = 0;
        region.mineProbability = 0.0;
        Stack<Point> stack = new Stack<Point>();
        stack.push(new Point(i, j));
        this.square[i][j].region = id;
        do {
            Point tempPoint = (Point)stack.pop();
            i = tempPoint.row;
            j = tempPoint.col;
            region.mineProbability += this.square[i][j].probability[9];
            ++region.squaresCount;
            if (i != DIMV - 1) {
                if (j != DIMH - 1 && this.square[i + 1][j + 1].value == null && this.square[i + 1][j + 1].region == 0 && this.square[i + 1][j + 1].mine != Boolean.TRUE) {
                    this.square[i + 1][j + 1].region = id;
                    stack.push(new Point(i + 1, j + 1));
                }
                if (j != 0 && this.square[i + 1][j - 1].value == null && this.square[i + 1][j - 1].region == 0 && this.square[i + 1][j - 1].mine != Boolean.TRUE) {
                    this.square[i + 1][j - 1].region = id;
                    stack.push(new Point(i + 1, j - 1));
                }
                if (this.square[i + 1][j].value == null && this.square[i + 1][j].region == 0 && this.square[i + 1][j].mine != Boolean.TRUE) {
                    this.square[i + 1][j].region = id;
                    stack.push(new Point(i + 1, j));
                }
            }
            if (j != DIMH - 1 && this.square[i][j + 1].value == null && this.square[i][j + 1].region == 0 && this.square[i][j + 1].mine != Boolean.TRUE) {
                this.square[i][j + 1].region = id;
                stack.push(new Point(i, j + 1));
            }
            if (j != 0 && this.square[i][j - 1].value == null && this.square[i][j - 1].region == 0 && this.square[i][j - 1].mine != Boolean.TRUE) {
                this.square[i][j - 1].region = id;
                stack.push(new Point(i, j - 1));
            }
            if (i == 0) continue;
            if (j != DIMH - 1 && this.square[i - 1][j + 1].value == null && this.square[i - 1][j + 1].region == 0 && this.square[i - 1][j + 1].mine != Boolean.TRUE) {
                this.square[i - 1][j + 1].region = id;
                stack.push(new Point(i - 1, j + 1));
            }
            if (j != 0 && this.square[i - 1][j - 1].value == null && this.square[i - 1][j - 1].region == 0 && this.square[i - 1][j - 1].mine != Boolean.TRUE) {
                this.square[i - 1][j - 1].region = id;
                stack.push(new Point(i - 1, j - 1));
            }
            if (this.square[i - 1][j].value != null || this.square[i - 1][j].region != 0 || this.square[i - 1][j].mine == Boolean.TRUE) continue;
            this.square[i - 1][j].region = id;
            stack.push(new Point(i - 1, j));
        } while (stack.size() > 0);
        this.regions.add(region);
    }

    void CalculateSecurePayoff() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                int index;
                if (this.square[i][j].probability[0] > 0.0 && this.square[i][j].region != 0) {
                    if (this.square[i][j].adjacents == this.regions.get((int)(this.square[i][j].region - 1)).squaresCount - 1) {
                        this.square[i][j].payoff[0] = 0.0;
                    } else {
                        double tempPayoff = this.regions.get((int)(this.square[i][j].region - 1)).mineProbability - this.square[i][j].probability[9];
                        double aproxPayoff = this.CalculateMMF(this.regions.get((int)(this.square[i][j].region - 1)).squaresCount);
                        double d = this.square[i][j].payoff[0] = aproxPayoff < tempPayoff ? aproxPayoff : tempPayoff;
                    }
                }
                if (this.square[i][j].probability[9] == 1.0) {
                    this.square[i][j].payoff[9] = 1.0;
                }
                if (!(this.square[i][j].probability[index = this.square[i][j].adjacentMines + this.square[i][j].adjacents] > 0.0) || index == 0) continue;
                this.square[i][j].payoff[index] = (double)(this.openSeaCount - 1) != this.leftMines ? (double)this.square[i][j].adjacents : this.leftMines;
            }
        }
    }

    void CalculatePayoff() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                Board tempBoard;
                char[][] tempLogicBoard;
                if (this.square[i][j].probability[9] > 0.0 && this.square[i][j].probability[9] < 1.0) {
                    tempLogicBoard = NightmareTools.megaClone(this.logicBoard);
                    tempLogicBoard[i][j] = 109;
                    tempBoard = new Board(tempLogicBoard, this.level + 1, this.MAXLEVEL);
                    this.square[i][j].payoff[9] = 1 + tempBoard.obviousMinesCount + tempBoard.notSoobviousMinesCount;
                }
                for (int k = 1; k <= this.square[i][j].adjacentMines + this.square[i][j].adjacents; ++k) {
                    if (!(this.square[i][j].probability[k] > 0.0)) continue;
                    tempLogicBoard = NightmareTools.megaClone(this.logicBoard);
                    tempLogicBoard[i][j] = (char)(k + 48);
                    tempBoard = new Board(tempLogicBoard, this.level + 1, this.MAXLEVEL);
                    this.square[i][j].payoff[k] = tempBoard.obviousMinesCount + tempBoard.notSoobviousMinesCount;
                }
            }
        }
    }

    void CalculateFastPayoff() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].mine == null) {
                    this.square[i][j].payoff[9] = 1.0;
                }
                if (this.square[i][j].inGroup != 0) continue;
                if (this.square[i][j].mine == Boolean.FALSE) {
                    if ((double)(this.openSeaCount - this.square[i][j].adjacents) != this.leftMines) continue;
                    this.square[i][j].payoff[this.square[i][j].adjacentMines] = this.leftMines;
                    continue;
                }
                if ((double)(this.openSeaCount - this.square[i][j].adjacents - 1) != this.leftMines) continue;
                this.square[i][j].payoff[this.square[i][j].adjacentMines] = this.leftMines;
            }
        }
    }

    void CalculateGroupsPayoff() {
        for (Group group : this.groups) {
            int col;
            int row;
            int j;
            int i;
            int[][] payoff = new int[group.unknown.size()][2];
            for (i = 0; i < group.unknown.size(); ++i) {
                boolean[][] tmpVector = new boolean[group.unknown.size()][2];
                for (j = 0; j < group.unknown.size(); ++j) {
                    tmpVector[j][0] = true;
                    tmpVector[j][1] = true;
                }
                for (boolean[] answer : group.answers) {
                    int j2;
                    if (!answer[i]) {
                        for (j2 = 0; j2 < group.unknown.size(); ++j2) {
                            boolean[] blArray = tmpVector[j2];
                            blArray[0] = blArray[0] & answer[j2];
                        }
                        continue;
                    }
                    for (j2 = 0; j2 < group.unknown.size(); ++j2) {
                        boolean[] blArray = tmpVector[j2];
                        blArray[1] = blArray[1] & answer[j2];
                    }
                }
                for (j = 0; j < 2; ++j) {
                    int cont = 0;
                    for (int k = 0; k < group.unknown.size(); ++k) {
                        row = group.unknown.get((int)k).row;
                        col = group.unknown.get((int)k).col;
                        if (!tmpVector[k][j] || this.square[row][col].mine != null) continue;
                        ++cont;
                    }
                    payoff[i][j] = cont;
                }
            }
            for (i = 0; i < group.unknown.size(); ++i) {
                row = group.unknown.get((int)i).row;
                col = group.unknown.get((int)i).col;
                int index = this.square[row][col].adjacentFixedMines + this.square[row][col].adjacentsOpenSea + group.unknown.get(i).MaxAdjacentMines();
                if (this.square[row][col].payoff[index] == 0.0) {
                    this.square[row][col].payoff[index] = this.square[row][col].adjacentsOpenSea;
                }
                this.square[row][col].payoff[9] = payoff[i][1];
                for (j = 1; j < 8; ++j) {
                    if (!(this.square[row][col].probability[j] > 0.0) || j == this.square[row][col].adjacents + this.square[row][col].adjacentMines) continue;
                    int n = j;
                    this.square[row][col].payoff[n] = this.square[row][col].payoff[n] + (double)payoff[i][0];
                }
            }
        }
    }

    void CalculateZonePayoff() {
        for (int j = 0; j < this.groups.size(); ++j) {
            for (int i = 0; i < this.groups.get((int)j).zone.size(); ++i) {
                int row = this.groups.get((int)j).zone.get((int)i).row;
                int col = this.groups.get((int)j).zone.get((int)i).col;
                int index = this.square[row][col].adjacentFixedMines + this.square[row][col].adjacentsOpenSea + this.groups.get((int)j).zone.get(i).MaxAdjacentMines();
                if (this.square[row][col].payoff[index] != 0.0) continue;
                this.square[row][col].payoff[index] = this.square[row][col].adjacentsOpenSea;
            }
        }
    }

    double CalculateMMF(int x) {
        return (0.8619593900000001 + 11.7807 * Math.pow(x, 0.691)) / (32.0431 + Math.pow(x, 0.691));
    }

    void ProcessSecondExpectedValue() {
        if (!this.PARETO) {
            for (int i = 0; i < DIMV; ++i) {
                for (int j = 0; j < DIMH; ++j) {
                    if (this.square[i][j].probability[0] > 0.0 && this.square[i][j].region != 0) {
                        if (this.square[i][j].adjacents == this.regions.get((int)(this.square[i][j].region - 1)).squaresCount - 1) {
                            this.square[i][j].payoff[0] = 0.0;
                        } else {
                            double tempPayoff = this.regions.get((int)(this.square[i][j].region - 1)).mineProbability;
                            double aproxPayoff = this.CalculateMMF(this.regions.get((int)(this.square[i][j].region - 1)).squaresCount);
                            this.square[i][j].payoff[0] = aproxPayoff < tempPayoff ? aproxPayoff : tempPayoff;
                        }
                    }
                    for (int k = 1; k <= 9; ++k) {
                        if (!(this.square[i][j].probability[k] > 0.0) || this.openSea[i][j] && !this.square[i][j].inZone) continue;
                        char[][] tempLogicBoard = NightmareTools.megaClone(this.logicBoard);
                        tempLogicBoard[i][j] = k != 9 ? (int)(k + 48) : 109;
                        Board tempBoard = new Board(tempLogicBoard, this.level + 1, this.MAXLEVEL);
                        tempBoard.FASTMODE = true;
                        tempBoard.Solve();
                        this.square[i][j].payoff[k] = k != 9 ? (double)tempBoard.foundMines : (double)(tempBoard.foundMines + 1);
                        this.square[i][j].expectedValues[k] = tempBoard.maxFirstExpectedValue;
                    }
                    this.onEvent((i * DIMV + j + DIMH) / (DIMH * DIMV), Enums.EventType.PROGRESS);
                }
            }
        } else {
            boolean[][] bestMaxExpectedValuePoints = this.BestMaxExpectedValuePoints();
            for (int i = 0; i < DIMH; ++i) {
                for (int j = 0; j < DIMV; ++j) {
                    if (!bestMaxExpectedValuePoints[i][j]) continue;
                    if (this.square[i][j].probability[0] > 0.0) {
                        double tempPayoff = this.regions.get((int)(this.square[i][j].region - 1)).mineProbability;
                        double aproxPayoff = this.CalculateMMF(this.regions.get((int)(this.square[i][j].region - 1)).squaresCount);
                        this.square[i][j].payoff[0] = aproxPayoff < tempPayoff ? aproxPayoff : tempPayoff;
                    }
                    for (int k = 1; k <= 9; ++k) {
                        if (!(this.square[i][j].probability[k] > 0.0)) continue;
                        char[][] tempLogicBoard = NightmareTools.megaClone(this.logicBoard);
                        tempLogicBoard[i][j] = k != 9 ? (int)(k + 48) : 109;
                        Board tempBoard = new Board(tempLogicBoard, this.level + 1, this.MAXLEVEL);
                        tempBoard.Solve();
                        this.square[i][j].payoff[k] = k != 9 ? (double)tempBoard.foundMines : (double)(tempBoard.foundMines + 1);
                        this.square[i][j].expectedValues[k] = tempBoard.maxFirstExpectedValue;
                    }
                }
            }
        }
    }

    void CalculateFirstExpectedValue() {
        this.maxFirstExpectedValue = -((double)MINES);
        this.minFirstExpectedValue = MINES;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].value != null || this.square[i][j].mine == Boolean.TRUE || this.square[i][j].probability[9] == 1.0) continue;
                this.square[i][j].firstExpectedValue = this.square[i][j].probability[9] * this.square[i][j].payoff[9];
                for (int k = 0; k < 9; ++k) {
                    if (!(this.square[i][j].probability[k] > 0.0)) continue;
                    if (this.square[i][j].firstExpectedValue != null) {
                        Square square = this.square[i][j];
                        Double.valueOf(square.firstExpectedValue - this.square[i][j].probability[k] * this.square[i][j].payoff[k]);
                        square.firstExpectedValue = square.firstExpectedValue;
                        continue;
                    }
                    this.square[i][j].firstExpectedValue = -this.square[i][j].probability[k] * this.square[i][j].payoff[k];
                }
                if (this.square[i][j].firstExpectedValue < this.minFirstExpectedValue) {
                    this.minFirstExpectedValue = this.square[i][j].firstExpectedValue;
                }
                if (!(this.square[i][j].firstExpectedValue > this.maxFirstExpectedValue)) continue;
                this.maxFirstExpectedValue = this.square[i][j].firstExpectedValue;
            }
        }
    }

    void CalculateExpectedValue() {
        this.maxExpectedValue = -MINES;
        this.minExpectedValue = MINES;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.square[i][j].value != null || this.square[i][j].mine != null || this.square[i][j].probability[9] == 1.0) continue;
                double expectedValue = this.square[i][j].probability[9] * (this.square[i][j].payoff[9] + this.square[i][j].expectedValues[9]);
                for (int k = 0; k < 9; ++k) {
                    expectedValue -= this.square[i][j].probability[k] * (this.square[i][j].payoff[k] + this.square[i][j].expectedValues[k]);
                }
                this.square[i][j].expectedValue = expectedValue;
                if (expectedValue < this.minExpectedValue) {
                    this.minExpectedValue = expectedValue;
                }
                if (!(expectedValue > this.maxExpectedValue)) continue;
                this.maxExpectedValue = expectedValue;
            }
        }
    }

    void additionalStep() {
        if (this.level == 1) {
            this.onEvent("Bomb", Enums.EventType.INFO);
            this.CalculateBombProbability();
            this.onEvent("WriteToFile", Enums.EventType.INFO);
            this.onEventLog("Last Board", Enums.LogLevel.INFO);
        }
    }

    void CalculateBombProbability() {
        for (int i = 2; i < DIMV - 2; ++i) {
            for (int j = 2; j < DIMH - 2; ++j) {
                int cont = 0;
                for (int i2 = i - 2; i2 <= i + 2; ++i2) {
                    for (int j2 = j - 2; j2 <= j + 2; ++j2) {
                        if (!this.openSea[i2][j2]) continue;
                        ++cont;
                    }
                }
                for (int k = 0; k <= 25; ++k) {
                    if (this.square[i][j].bombProbability == null) {
                        throw new NullPointerException("bombProbability not set at " + i + ", " + j);
                    }
                    this.square[i][j].bombProbability[k] = Combinatory.HypergeometricDistribution(k, cont, (int)this.leftMines, this.openSeaCount);
                }
            }
        }
    }

    void UpdateLogicBoard() {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (this.obviousMines[i][j] || this.notSoObviousMines[i][j]) {
                    this.logicBoard[i][j] = 109;
                    continue;
                }
                if (!this.obviousNotMines[i][j] && !this.notSoObviousNotMines[i][j]) continue;
                this.logicBoard[i][j] = 119;
            }
        }
    }

    void ClearBoardMemory() {
        this.leftMines = MINES;
        this.solved = false;
        this.firstStep = false;
        this.lastStep = false;
        this.initialMines = 0;
        this.initialRedMines = 0;
        this.initialBlueMines = 0;
        this.obviousMinesCount = 0;
        this.obviousNotMinesCount = 0;
        this.notSoobviousMinesCount = 0;
        this.notSoobviousNotMinesCount = 0;
        this.square = new Square[DIMV][DIMH];
        this.initSquares();
        this.openSea = new boolean[DIMV][DIMH];
        this.regions.clear();
        this.groups.clear();
        this.permutations.clear();
        this.answersFrequencies.clear();
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                this.obviousMines[i][j] = false;
                this.obviousNotMines[i][j] = false;
                this.notSoObviousMines[i][j] = false;
                this.notSoObviousNotMines[i][j] = false;
                this.square[i][j].probability = new double[10];
                this.square[i][j].payoff = new double[10];
                this.square[i][j].expectedValues = new double[10];
            }
        }
    }

    public String toString() {
        int j1;
        int i1;
        String tmpString;
        int j;
        int i;
        StringBuilder StringBuilder2 = new StringBuilder();
        StringBuilder2.append("HORIZONTAL DIMENSION: " + DIMH);
        StringBuilder2.append("\r\nVERTICAL DIMENSION: " + DIMV);
        StringBuilder2.append("\r\nBOARD MINES: " + MINES);
        StringBuilder2.append("\r\nLOGIC BOARD\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.logicBoard[i][j]);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Values\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                tmpString = this.square[i][j].value != null ? this.square[i][j].value.toString() : "-";
                StringBuilder2.append(tmpString);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Mines\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                tmpString = this.square[i][j].mine != null ? (this.square[i][j].mine.booleanValue() ? "1" : "0") : "-";
                StringBuilder2.append(tmpString);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Virtual Value\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                tmpString = this.square[i][j].value != null ? Integer.valueOf(this.square[i][j].virtualValue).toString() : "-";
                StringBuilder2.append(tmpString);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Adjacents\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.square[i][j].adjacents);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Adjacent Mines\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.square[i][j].adjacentMines);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Adjacent Values\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.square[i][j].adjacentValues);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Open Sea\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                tmpString = this.openSea[i][j] ? "1 " : "0 ";
                StringBuilder2.append(tmpString);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Adjacents OpenSea\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.square[i][j].adjacentsOpenSea);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("In Group\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.square[i][j].inGroup);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("In Zone\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                tmpString = this.square[i][j].inZone ? "1 " : "0 ";
                StringBuilder2.append(tmpString);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("Regions\r\n");
        for (i = 0; i < DIMV; ++i) {
            for (j = 0; j < DIMH; ++j) {
                StringBuilder2.append(this.square[i][j].region);
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("\r\nGENERAL VALUES\r\n");
        StringBuilder2.append("\tInitial Mines: " + Integer.valueOf(this.initialMines).toString());
        StringBuilder2.append("\tInitial Blue Mines: " + Integer.valueOf(this.initialBlueMines).toString());
        StringBuilder2.append("\tInitial Red Mines: " + Integer.valueOf(this.initialRedMines).toString());
        StringBuilder2.append("\tFound Mines: " + Integer.valueOf(this.foundMines).toString());
        StringBuilder2.append("\tLeft Mines: " + Double.valueOf(this.leftMines).toString());
        StringBuilder2.append("\tOpen Sea size(): " + Integer.valueOf(this.openSeaCount).toString());
        if (this.maxFirstExpectedValue != null) {
            StringBuilder2.append("\n\tMaximum First Expected Value: " + this.maxFirstExpectedValue.toString());
        } else {
            StringBuilder2.append("\n\tMaximum First Expected Value: -");
        }
        if (this.minFirstExpectedValue != null) {
            StringBuilder2.append("\n\tMinimum First Expected Value: " + this.minFirstExpectedValue.toString());
        } else {
            StringBuilder2.append("\n\tMinimum First Expected Value: -");
        }
        if (this.maxExpectedValue != null) {
            StringBuilder2.append("\n\tMaximum Second Expected Value: " + this.maxExpectedValue.toString());
        } else {
            StringBuilder2.append("\n\tMaximum Second Expected Value: -");
        }
        if (this.minExpectedValue != null) {
            StringBuilder2.append("\n\tMinimum Second Expected Value: " + this.minExpectedValue.toString());
        } else {
            StringBuilder2.append("\n\tMinimum Second Expected Value: -");
        }
        StringBuilder2.append("\n\tObvious Mines: ");
        int cont = 0;
        if (this.obviousMinesCount == 0) {
            StringBuilder2.append("None");
        } else {
            for (i1 = 0; i1 < DIMV; ++i1) {
                for (j1 = 0; j1 < DIMH; ++j1) {
                    if (!this.obviousMines[i1][j1]) continue;
                    StringBuilder2.append("[%d , %d]", i1, j1);
                    if (cont != this.obviousMinesCount - 1) {
                        StringBuilder2.append(", ");
                    }
                    ++cont;
                }
            }
        }
        StringBuilder2.append("\n");
        StringBuilder2.append("\tObvious Not Mines: ");
        if (this.obviousNotMinesCount == 0) {
            StringBuilder2.append("None");
        } else {
            cont = 0;
            for (i1 = 0; i1 < DIMV; ++i1) {
                for (j1 = 0; j1 < DIMH; ++j1) {
                    if (!this.obviousNotMines[i1][j1]) continue;
                    StringBuilder2.append("[%d, %d]", i1, j1);
                    if (cont != this.obviousNotMinesCount - 1) {
                        StringBuilder2.append(", ");
                    }
                    ++cont;
                }
            }
        }
        StringBuilder2.append("\n");
        StringBuilder2.append("\tNot So Obvious Mines: ");
        if (this.notSoobviousMinesCount == 0) {
            StringBuilder2.append("None");
        } else {
            cont = 0;
            for (i1 = 0; i1 < DIMV; ++i1) {
                for (j1 = 0; j1 < DIMH; ++j1) {
                    if (!this.notSoObviousMines[i1][j1]) continue;
                    StringBuilder2.append("[%d , %d]", i1, j1);
                    if (cont != this.notSoobviousMinesCount - 1) {
                        StringBuilder2.append(", ");
                    }
                    ++cont;
                }
            }
        }
        StringBuilder2.append("\n");
        StringBuilder2.append("\tNot So Obvious Not Mines: ");
        if (this.notSoobviousNotMinesCount == 0) {
            StringBuilder2.append("None");
        } else {
            cont = 0;
            for (i1 = 0; i1 < DIMV; ++i1) {
                for (j1 = 0; j1 < DIMH; ++j1) {
                    if (!this.notSoObviousNotMines[i1][j1]) continue;
                    StringBuilder2.append("[%d , %d]", i1, j1);
                    if (cont != this.notSoobviousNotMinesCount - 1) {
                        StringBuilder2.append(", ");
                    }
                    ++cont;
                }
            }
        }
        StringBuilder2.append("\n");
        StringBuilder2.append("Groups\r\n");
        if (this.groups.size() == 0) {
            StringBuilder2.append("\tNone");
        }
        for (i = 0; i < this.groups.size(); ++i) {
            StringBuilder2.append("[" + i + "]\r\n" + this.groups.get(i).toString());
        }
        StringBuilder2.append("Permutations\r\n");
        if (this.permutations.size() == 0) {
            StringBuilder2.append("\tNone");
        }
        for (i = 0; i < this.permutations.size(); ++i) {
            StringBuilder2.append("[" + i + "]\r\n" + this.permutations.get(i).toString() + "\r\n");
        }
        StringBuilder2.append("\n");
        StringBuilder2.append("\n");
        StringBuilder2.append("StringBuilder Capacity: " + StringBuilder2.capacity());
        return StringBuilder2.toString();
    }

    void Function1() {
        int[] arreglo1 = new int[1000];
        for (int i = 0; i < 1000; ++i) {
            arreglo1[i] = 2;
        }
    }

    void Function2() {
        int[] arreglo1 = new int[1000];
        for (int i = 0; i < 1000; ++i) {
            arreglo1[i] = 2;
        }
    }

    public double Benchmark() {
        int i;
        Runnable task1 = new Runnable(){

            @Override
            public void run() {
                Board.this.Function1();
            }
        };
        Runnable task2 = new Runnable(){

            @Override
            public void run() {
                Board.this.Function2();
            }
        };
        Counter counter = new Counter();
        int n = 200000;
        counter.Start();
        counter.Stop();
        counter.Reset();
        counter.Start();
        for (i = 0; i < n; ++i) {
            task1.run();
        }
        counter.Stop();
        float time1 = counter.TaskTime();
        counter.Reset();
        counter.Start();
        for (i = 0; i < n; ++i) {
            task2.run();
        }
        counter.Stop();
        float time2 = counter.TaskTime();
        counter.Reset();
        return time2 / time1;
    }

    public void SetLogicBoard(char[][] value) {
        this.ClearBoardMemory();
        this.logicBoard = value;
        this.InitializeLogicBoard();
    }

    public static void Simulate(Board board, int seconds) {
        double[][][] frequencyBoard = new double[DIMV][DIMH][MINES + 1];
        double[][] expandPayoff = new double[DIMV][DIMH];
        double[][] expandStd = new double[DIMV][DIMH];
        Board tmpBoard = new Board();
        tmpBoard.OnEventLog = board.OnEventLog;
        Random random = RandomFactory.Create();
        int iterations = 0;
        Counter counter = new Counter();
        counter.Start();
        while (counter.TotalTime() < (float)(seconds * 1000)) {
            char[][] tmpLogicBoard1 = NightmareTools.megaClone(board.logicBoard);
            for (Group group : board.groups) {
                for (UnknownPoint point : group.unknown) {
                    tmpLogicBoard1[point.row][point.col] = 63;
                }
                boolean[] answer = group.answers.get(random.nextInt(group.answers.size()));
                for (int i = 0; i < group.unknown.size(); ++i) {
                    if (!answer[i]) continue;
                    tmpLogicBoard1[group.unknown.get((int)i).row][group.unknown.get((int)i).col] = 109;
                }
            }
            char[][] randomBoard = Board.RandomBoard(tmpLogicBoard1);
            Board.CalculateFrequencyBoard(frequencyBoard, board, tmpBoard, randomBoard);
            if (++iterations % 100 != 0) continue;
            board.onEvent(counter.TaskTime() / (float)(seconds * 1000), Enums.EventType.PROGRESS);
        }
        counter.Stop();
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                int k;
                double total = 0.0;
                double ocurrences = 0.0;
                double std = 0.0;
                for (k = 0; k <= MINES; ++k) {
                    total += frequencyBoard[i][j][k] * (double)k;
                    ocurrences += frequencyBoard[i][j][k];
                }
                if (!(ocurrences > 0.0)) continue;
                double mean = total / ocurrences;
                for (k = 0; k <= MINES; ++k) {
                    if (frequencyBoard[i][j][k] == 0.0) continue;
                    std += frequencyBoard[i][j][k] * Math.pow((double)k - mean, 2.0);
                }
                expandStd[i][j] = Math.sqrt(std / ocurrences);
                expandPayoff[i][j] = mean;
            }
        }
        board.ExpandStd(expandStd);
        board.ExpandPayoff(expandPayoff);
        board.CalculateFirstExpectedValue();
        if (board.MAXLEVEL > 1) {
            board.CalculateExpectedValue();
        }
        double evSum = 0.0;
        double probSum = 0.0;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                evSum += board.square[i][j].probability[0] * board.square[i][j].payoff[0];
                probSum += board.square[i][j].probability[0];
            }
        }
        double generalPayoff = evSum / probSum;
        StringBuilder StringBuilder2 = new StringBuilder();
        StringBuilder2.append("Payoff\r\n");
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                StringBuilder2.append(expandPayoff[i][j] + "\t");
            }
            StringBuilder2.append("\n");
        }
        StringBuilder2.append("\n");
        StringBuilder2.append("General Payoff: " + generalPayoff);
        Logger.getLogger("Board").fine(StringBuilder2.toString());
    }

    private static void CalculateFrequencyBoard(double[][][] frequencyBoard, Board board, Board tmpBoard, char[][] tmpLogicBoard1) {
        boolean[][] expandedRegion = new boolean[DIMV][DIMH];
        boolean[][] considered = new boolean[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (tmpLogicBoard1[i][j] != '0' || considered[i][j]) continue;
                considered[i][j] = true;
                char[][] tmpLogicBoard2 = NightmareTools.megaClone(board.logicBoard);
                Board.Expand(tmpLogicBoard2, tmpLogicBoard1, new Point(i, j), expandedRegion);
                tmpBoard.SetLogicBoard(tmpLogicBoard2);
                int actualMines = tmpBoard.obviousMinesCount + tmpBoard.notSoobviousMinesCount;
                for (int i2 = 0; i2 < DIMV; ++i2) {
                    for (int j2 = 0; j2 < DIMH; ++j2) {
                        if (!expandedRegion[i2][j2]) continue;
                        considered[i2][j2] = true;
                        double[] dArray = frequencyBoard[i2][j2];
                        int n = actualMines;
                        dArray[n] = dArray[n] + 1.0;
                    }
                }
            }
        }
    }

    public static char[][] RandomBoard() {
        int DIMH = Configuration.BasicConfig().DIMH;
        int DIMV = Configuration.BasicConfig().DIMV;
        int MINES = Configuration.BasicConfig().MINES;
        char[][] rtn = new char[DIMV][DIMH];
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                rtn[i][j] = 63;
            }
        }
        ArrayList<Point> randomMines = new ArrayList<Point>(MINES);
        Random random = RandomFactory.Create();
        do {
            int col;
            int row;
            Point tmpMine;
            if (randomMines.contains(tmpMine = new Point(row = (int)Math.floor(random.nextInt(DIMV)), col = (int)Math.floor(random.nextInt(DIMH))))) continue;
            randomMines.add(tmpMine);
        } while (randomMines.size() < MINES);
        for (int i = 0; i < randomMines.size(); ++i) {
            rtn[((Point)randomMines.get((int)i)).row][((Point)randomMines.get((int)i)).col] = i % 2 == 0 ? 98 : 114;
        }
        Board.SetValues(rtn, DIMV, DIMH, MINES);
        return rtn;
    }

    public static void Click(char[][] logicBoard, char[][] randomBoard, Point point) throws Exception {
        boolean[][] expanded = new boolean[16][16];
        logicBoard[point.row][point.col] = randomBoard[point.row][point.col];
        if (randomBoard[point.row][point.col] == '0') {
            Board.Expand(logicBoard, randomBoard, point, expanded);
        }
    }

    public static void RandomClick(char[][] logicBoard, char[][] randomBoard) throws Exception {
        Random random = RandomFactory.Create();
        Board.Click(logicBoard, randomBoard, new Point(random.nextInt(16), random.nextInt(16)));
    }

    public static void Expand(char[][] logicBoard, Point point) {
        if (logicBoard[point.row][point.col] != '?') {
            return;
        }
        int DIMH = Configuration.SolverConfig().DIMH;
        int DIMV = Configuration.SolverConfig().DIMV;
        ArrayList<Point> tmpList = new ArrayList<Point>();
        int listIndex = 0;
        tmpList.add(point);
        do {
            Point tmpPoint = (Point)tmpList.get(listIndex);
            int row = tmpPoint.row;
            int col = tmpPoint.col;
            if (row != DIMV - 1 && logicBoard[row + 1][col] == '?' && !tmpList.contains(tmpPoint = new Point(row + 1, col))) {
                tmpList.add(new Point(row + 1, col));
            }
            if (col != DIMH - 1 && logicBoard[row][col + 1] == '?' && !tmpList.contains(tmpPoint = new Point(row, col + 1))) {
                tmpList.add(new Point(row, col + 1));
            }
            if (col != 0 && logicBoard[row][col - 1] == '?' && !tmpList.contains(tmpPoint = new Point(row, col - 1))) {
                tmpList.add(new Point(row, col - 1));
            }
            if (row == 0 || logicBoard[row - 1][col] != '?' || tmpList.contains(tmpPoint = new Point(row - 1, col))) continue;
            tmpList.add(new Point(row - 1, col));
        } while (++listIndex < tmpList.size());
        for (int i = 0; i < tmpList.size(); ++i) {
            logicBoard[((Point)tmpList.get((int)i)).row][((Point)tmpList.get((int)i)).col] = 48;
        }
    }

    public static void Expand(char[][] logicBoard, char[][] randomBoard, Point point, boolean[][] expanded) {
        if (randomBoard[point.row][point.col] != '0') {
            throw new AssertionError((Object)String.format("Cannot expand at a non-expanding field. Point %s. Value %c", point.toString(), Character.valueOf(randomBoard[point.row][point.col])));
        }
        int DIMH = Configuration.SolverConfig().DIMH;
        int DIMV = Configuration.SolverConfig().DIMV;
        expanded = new boolean[DIMV][DIMH];
        ArrayList<Point> tmpList = new ArrayList<Point>();
        int listIndex = 0;
        tmpList.add(point);
        do {
            Point tmpPoint = (Point)tmpList.get(listIndex);
            int row = tmpPoint.row;
            int col = tmpPoint.col;
            if (randomBoard[row][col] >= '1' && randomBoard[row][col] <= '8') continue;
            if (row != DIMV - 1) {
                if (col != DIMH - 1 && randomBoard[row + 1][col + 1] != 'm' && !tmpList.contains(tmpPoint = new Point(row + 1, col + 1))) {
                    tmpList.add(tmpPoint);
                }
                if (col != 0 && randomBoard[row + 1][col - 1] != 'm' && !tmpList.contains(tmpPoint = new Point(row + 1, col - 1))) {
                    tmpList.add(new Point(row + 1, col - 1));
                }
                if (randomBoard[row + 1][col] != 'm' && !tmpList.contains(tmpPoint = new Point(row + 1, col))) {
                    tmpList.add(new Point(row + 1, col));
                }
            }
            if (col != DIMH - 1 && randomBoard[row][col + 1] != 'm' && !tmpList.contains(tmpPoint = new Point(row, col + 1))) {
                tmpList.add(new Point(row, col + 1));
            }
            if (col != 0 && randomBoard[row][col - 1] != 'm' && !tmpList.contains(tmpPoint = new Point(row, col - 1))) {
                tmpList.add(new Point(row, col - 1));
            }
            if (row == 0) continue;
            if (col != DIMH - 1 && randomBoard[row - 1][col + 1] != 'm' && !tmpList.contains(tmpPoint = new Point(row - 1, col + 1))) {
                tmpList.add(new Point(row - 1, col + 1));
            }
            if (col != 0 && randomBoard[row - 1][col - 1] != 'm' && !tmpList.contains(tmpPoint = new Point(row - 1, col - 1))) {
                tmpList.add(new Point(row - 1, col - 1));
            }
            if (randomBoard[row - 1][col] == 'm' || tmpList.contains(tmpPoint = new Point(row - 1, col))) continue;
            tmpList.add(new Point(row - 1, col));
        } while (++listIndex < tmpList.size());
        for (int i = 0; i < tmpList.size(); ++i) {
            if (randomBoard[((Point)tmpList.get((int)i)).row][((Point)tmpList.get((int)i)).col] == '0') {
                expanded[((Point)tmpList.get((int)i)).row][((Point)tmpList.get((int)i)).col] = true;
            }
            logicBoard[((Point)tmpList.get((int)i)).row][((Point)tmpList.get((int)i)).col] = randomBoard[((Point)tmpList.get((int)i)).row][((Point)tmpList.get((int)i)).col];
        }
    }

    public static char[][] RandomBoard(char[][] logicBoard) {
        int cont = 0;
        int DIMV = Configuration.SolverConfig().DIMV;
        int DIMH = Configuration.SolverConfig().DIMH;
        int MINES = Configuration.SolverConfig().MINES;
        boolean[][] randomMines = new boolean[Configuration.SolverConfig().DIMV][Configuration.SolverConfig().DIMH];
        char[][] randomBoard = NightmareTools.megaClone(logicBoard);
        Random random = new Random();
        int initialMines = 0;
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                if (logicBoard[i][j] != 'm' && logicBoard[i][j] != 'r' && logicBoard[i][j] != 'b') continue;
                ++initialMines;
            }
        }
        do {
            int col;
            int row;
            if (logicBoard[row = random.nextInt(DIMV)][col = random.nextInt(DIMH)] != '?' || randomMines[row][col]) continue;
            randomMines[row][col] = true;
            randomBoard[row][col] = cont % 2 == 0 ? 98 : 114;
            ++cont;
        } while (cont < MINES - initialMines);
        Board.SetValues(randomBoard, DIMV, DIMH, MINES);
        return randomBoard;
    }

    static void SetValues(char[][] logicboard, int DIMV, int DIMH, int MINES) {
        for (int i = 0; i < DIMV; ++i) {
            for (int j = 0; j < DIMH; ++j) {
                int adjacentsMines = 0;
                if (logicboard[i][j] == 'm' || logicboard[i][j] == 'b' || logicboard[i][j] == 'r') continue;
                if (i != DIMV - 1) {
                    if (j != DIMH - 1 && (logicboard[i + 1][j + 1] == 'm' || logicboard[i + 1][j + 1] == 'b' || logicboard[i + 1][j + 1] == 'r')) {
                        ++adjacentsMines;
                    }
                    if (j != 0 && (logicboard[i + 1][j - 1] == 'm' || logicboard[i + 1][j - 1] == 'b' || logicboard[i + 1][j - 1] == 'r')) {
                        ++adjacentsMines;
                    }
                    if (logicboard[i + 1][j] == 'm' || logicboard[i + 1][j] == 'b' || logicboard[i + 1][j] == 'r') {
                        ++adjacentsMines;
                    }
                }
                if (j != DIMH - 1 && (logicboard[i][j + 1] == 'm' || logicboard[i][j + 1] == 'b' || logicboard[i][j + 1] == 'r')) {
                    ++adjacentsMines;
                }
                if (j != 0 && (logicboard[i][j - 1] == 'm' || logicboard[i][j - 1] == 'b' || logicboard[i][j - 1] == 'r')) {
                    ++adjacentsMines;
                }
                if (i != 0) {
                    if (j != DIMH - 1 && (logicboard[i - 1][j + 1] == 'm' || logicboard[i - 1][j + 1] == 'b' || logicboard[i - 1][j + 1] == 'r')) {
                        ++adjacentsMines;
                    }
                    if (j != 0 && (logicboard[i - 1][j - 1] == 'm' || logicboard[i - 1][j - 1] == 'b' || logicboard[i - 1][j - 1] == 'r')) {
                        ++adjacentsMines;
                    }
                    if (logicboard[i - 1][j] == 'm' || logicboard[i - 1][j] == 'b' || logicboard[i - 1][j] == 'r') {
                        ++adjacentsMines;
                    }
                }
                logicboard[i][j] = (char)(adjacentsMines + 48);
            }
        }
    }

    public int getDIMV() {
        return DIMV;
    }

    public int getDIMH() {
        return DIMH;
    }

    public void javaGarbage() {
        if (this.groups != null) {
            for (Group grp : this.groups) {
                grp.javaGarbage();
            }
        }
        this.logicBoard = null;
        if (this.square != null) {
            for (Square[] sqarr : this.square) {
                if (sqarr == null) continue;
                for (Square sq : sqarr) {
                    sq.javaGarbage();
                }
            }
        }
        this.square = null;
        this.obviousMines = null;
        this.obviousNotMines = null;
        this.notSoObviousMines = null;
        this.notSoObviousNotMines = null;
        if (this.permutations != null) {
            for (Permutation perm : this.permutations) {
                perm.javaGarbage();
            }
        }
        if (this.answersFrequencies != null) {
            this.answersFrequencies.clear();
        }
        if (this.regions != null) {
            this.regions.clear();
        }
        this.maxFirstExpectedValue = null;
        this.minFirstExpectedValue = null;
        this.maxExpectedValue = null;
        this.minExpectedValue = null;
        this.configuration = null;
        this.openSea = null;
    }
}

