/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin.classic;

import java.util.Random;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.PlayerEliminateCheckEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class WinByLose
extends MinesweeperPlugin
implements EventListener {
    private Random rand = new Random();

    @Event
    public void onEliminate(PlayerEliminateCheckEvent event) {
        event.setCancelled(true);
        MinesweeperPlayingPlayer player = event.getPlayingPlayer();
        for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
            if (pp == player || pp.getScore() + event.getMap().getMinesLeft() <= player.getScore()) continue;
            return;
        }
        player.eliminateLoss();
    }

    @Event
    public void onFirstClick(PlayerMoveEvent event) {
        if (event.getMap().getMoveHistory().isEmpty()) {
            MineprobabilityAnalyze analyze = new MineprobabilityAnalyze(event.getMap());
            MinesweeperField field = event.getMove().getField();
            analyze.addRule((RuleConstraint)MineprobabilityAnalyze.ruleForField(field, false));
            analyze.addRule((RuleConstraint)MineprobabilityAnalyze.ruleFromField(field, 0));
            AnalyzeResult solve = analyze.solve();
            MineprobHelper.regenerate(event.getMap(), (AnalyzeResult<MinesweeperField>)solve, this.rand);
        }
    }

    public void onDisable() {
    }

    public void onEnable() {
        this.registerListener((EventListener)new EndShowMines());
        this.registerListener((EventListener)new StandardNeighbors());
        this.registerListener((EventListener)new StandardWeapons());
        this.registerListener(this);
    }

    public boolean canBeChosenBy(MinesweeperPlayer arg0) {
        return true;
    }
}

