/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.weapons.classic.ClickWeapon;

public class OpenFieldAnalyzer {
    private final MinesweeperMap map;
    private static Random random = new Random();

    public OpenFieldAnalyzer(MinesweeperMap map) {
        this.map = map;
    }

    public Map<MinesweeperField, Double> analyzePossibleOpenFields(int totalTime) {
        HashMap<MinesweeperField, Double> result = new HashMap<MinesweeperField, Double>();
        List unclicked = this.map.getAllUnclickedFields();
        if (unclicked.isEmpty()) {
            return result;
        }
        int tests = totalTime / unclicked.size();
        String str = this.map.saveMap();
        for (MinesweeperField ff : unclicked) {
            double dbl;
            if (ff.isClicked() || !((dbl = OpenFieldAnalyzer.getExpected100fromOpenField(str, ff, tests, false)) > 0.0)) continue;
            result.put(ff, dbl);
        }
        return result;
    }

    public static double getExpected100fromOpenField(String map, MinesweeperField field, int tests, boolean testsAsTime) {
        MinesweeperMap tempMap = field.getMap().getMapFactory().withTwoPlayers().loadFrom(map).map();
        field = tempMap.getPosition(field.getX(), field.getY());
        for (MinesweeperField ff : field.getNeighbors()) {
            if (!ff.isClicked() || !ff.isMine()) continue;
            return -2.147483648E9;
        }
        MineprobabilityAnalyze analyze = new MineprobabilityAnalyze(tempMap);
        analyze.addRule((RuleConstraint)MineprobabilityAnalyze.ruleFromField(field, 0));
        analyze.addRule((RuleConstraint)MineprobabilityAnalyze.ruleForField(field, false));
        AnalyzeResult result = analyze.solve();
        OpenFieldAnalyzer.clearHiddenMines(tempMap);
        if (result.getTotal() == 0.0) {
            return -2.147483648E9;
        }
        int start100 = MineprobHelper.find100(result);
        int total = 0;
        field = tempMap.getPosition(field.getX(), field.getY());
        ClickWeapon weapon = new ClickWeapon();
        int totalTests = 0;
        if (!testsAsTime) {
            for (int i = 0; i < tests; ++i) {
                ++totalTests;
                tempMap.loadMap(map);
                total += OpenFieldAnalyzer.getExpected100fromOpenFieldIteration(tempMap, (AnalyzeResult<MinesweeperField>)result, random, field, (MinesweeperWeapon)weapon, start100);
            }
        } else {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < (long)tests) {
                ++totalTests;
                tempMap.loadMap(map);
                total += OpenFieldAnalyzer.getExpected100fromOpenFieldIteration(tempMap, (AnalyzeResult<MinesweeperField>)result, random, field, (MinesweeperWeapon)weapon, start100);
            }
        }
        return 1.0 * (double)total / (double)totalTests;
    }

    private static void clearHiddenMines(MinesweeperMap tempMap) {
        for (MinesweeperField ff : tempMap.getIteration()) {
            if (ff.isClicked() || !ff.isMine()) continue;
            ff.setMine(false);
        }
        tempMap.saveMap();
    }

    private static int getExpected100fromOpenFieldIteration(MinesweeperMap tempMap, AnalyzeResult<MinesweeperField> analyze, Random random, MinesweeperField field, MinesweeperWeapon weapon, int start100) {
        MineprobHelper.regenerate(tempMap, analyze, random);
        if (field.isClicked()) {
            throw new AssertionError((Object)(field.toString() + " is already clicked. " + field.getMap().saveMap()));
        }
        if (field.isMine()) {
            throw new AssertionError((Object)(field.toString() + " is a mine. " + field.getMap().saveMap()));
        }
        if (field.getValue() != 0) {
            throw new AssertionError((Object)(field.toString() + " is a " + field.getValue() + ". " + field.getMap().saveMap()));
        }
        weapon.useAt(field.getMap().createMove(null, weapon, field));
        MineprobabilityAnalyze analyze2 = new MineprobabilityAnalyze(tempMap);
        AnalyzeResult result2 = analyze2.solve();
        return MineprobHelper.find100(result2) - start100;
    }
}

