/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.post;

import java.util.List;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.ais.utils.ChickenAnalyze;
import net.zomis.minesweeper.ais.utils.OpenField;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.PostScorer;

public class ChickenPlayCounter
extends PostScorer {
    @Override
    public void handle(FieldScores scores) {
        if (!this.weaponIsClick(scores.getWeapon())) {
            return;
        }
        ProbabilityKnowledge<MinesweeperField> theField = scores.getAnalyze().getKnowledgeFor(scores.getRankings()[0][0]);
        if (theField.getMineProbability() == 0.0) {
            this.performChickenAnalyze(scores);
            return;
        }
    }

    private void performChickenAnalyze(FieldScores scores) {
        ChickenAnalyze chicken = new ChickenAnalyze(scores.getPlayer().getMap(), scores.getAnalyze());
        chicken.analyze();
        int unevenConsideration = this.unevenIsDangerous(chicken) ? 0 : 1;
        List<OpenField> opens = chicken.getOpenFields();
        if (opens.size() > 1) {
            if (chicken.getSafeCount() % 2 + opens.size() == 1 - unevenConsideration ? this.playOpenField(scores, opens, false) : this.playOpenField(scores, opens, true)) {
                return;
            }
            if (this.playOpenField(scores, opens, false)) {
                return;
            }
            if (this.playOpenField(scores, opens, true)) {
                return;
            }
        } else if (opens.size() == 1) {
            OpenField of = opens.get(0);
            if (chicken.getSafeCount() % 2 == unevenConsideration) {
                this.force(scores, of.getOpenFieldSource(), 4.2);
            } else if (of.getNeighbors().isEmpty()) {
                this.force(scores, of.getOpenFieldSource(), 4.2);
            } else {
                this.force(scores, (MinesweeperField)UtilZomisList.getRandom(of.getNeighbors()), 2.1);
            }
        } else if (chicken.getSafeCount() == 0) {
            this.analyzeUnsafe(scores, chicken);
        }
    }

    private void analyzeUnsafe(FieldScores scores, ChickenAnalyze chicken) {
        for (MinesweeperField field : chicken.getUnsafe()) {
            int revealed = chicken.getSafeRevealedBy(scores.getAnalyze(), scores.getAnalyze().getKnowledgeFor(field));
            if (revealed % 2 == 0) {
                this.forceSet(scores, field, 0.01);
                continue;
            }
            this.forceSet(scores, field, -9.0);
        }
    }

    private boolean playOpenField(FieldScores scores, List<OpenField> openFields, boolean playOdd) {
        for (OpenField of : openFields) {
            if (of.isEven() != !playOdd) continue;
            this.force(scores, of.getOpenFieldSource(), 42.0);
            return true;
        }
        return false;
    }

    private boolean unevenIsDangerous(ChickenAnalyze chicken) {
        return true;
    }
}

