/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.probability;

@Deprecated
public class BigDouble {
    int[] num = new int[150];
    int intLength = 0;
    int decLength = 0;
    boolean positive = true;
    static final int capacity = 150;
    static final int point = 140;
    static final int b = 65536;
    static final int shift = 16;
    static final double EPSILON = 1.0E-6;

    public BigDouble() {
    }

    public BigDouble(int _int) {
        boolean bl = this.positive = _int >= 0;
        if (_int < 65536) {
            this.num[139] = _int;
            this.intLength = _int == 0 ? 0 : 1;
            return;
        }
        int i = 139;
        while (_int > 0) {
            this.num[i] = _int % 65536;
            _int >>= 16;
            --i;
        }
        this.intLength = 140 - i - 1;
    }

    public BigDouble(double number) {
        int i;
        double _int = Math.floor(number);
        double _dec = number - _int;
        for (i = 139; i >= 0 && _int > 0.0; --i) {
            this.num[i] = (int)(_int % 65536.0);
            _int = Math.floor(_int / 65536.0);
        }
        this.intLength = 140 - i - 1;
        for (i = 140; _dec > 0.0 && i < 150; ++i) {
            double aux = Math.floor(_dec * 65536.0);
            this.num[i] = (int)aux;
            _dec = _dec * 65536.0 - aux;
            if (this.num[i] <= 0) continue;
            this.decLength = i - 140 + 1;
        }
        this.positive = number >= 0.0;
    }

    public BigDouble(BigDouble bigDouble) {
        int index = 140 - bigDouble.intLength;
        int length = bigDouble.decLength + bigDouble.intLength;
        for (int i = index; i < length; ++i) {
            bigDouble.num[i] = this.num[i];
        }
        this.positive = bigDouble.positive;
        this.intLength = bigDouble.intLength;
        this.decLength = bigDouble.decLength;
    }

    private BigDouble(BigDouble bigDouble, int ini, int fin) {
        for (int i = fin - ini; i >= 0; --i) {
            this.num[140 - i - 1] = bigDouble.num[fin - i];
        }
        this.intLength = fin - ini + 1;
    }

    public int get(int index) {
        return this.num[index];
    }

    public void set(int index, int value) {
        this.num[index] = value;
    }

    public static BigDouble Factorial(int n) {
        if (n == 0 || n == 1) {
            return new BigDouble(1);
        }
        return new BigDouble(BigDouble.Multy(new BigDouble(n), BigDouble.Factorial(n - 1)));
    }

    public String toString() {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.positive) {
            stringBuilder.append("+");
        } else {
            stringBuilder.append("-");
        }
        for (i = 140 - this.intLength; i < 140; ++i) {
            stringBuilder.append(Integer.valueOf(this.num[i]).toString() + " ");
        }
        stringBuilder.append(". ");
        while (i < 140 + this.decLength) {
            stringBuilder.append(Integer.valueOf(this.num[i]).toString() + " ");
            ++i;
        }
        return stringBuilder.toString();
    }

    public double ToDouble() {
        int i;
        double ent = 0.0;
        double dec = 0.0;
        for (i = 140 - this.intLength; i < 140; ++i) {
            ent *= 65536.0;
            ent += (double)this.num[i];
        }
        for (i = 140 + this.decLength - 1; i >= 140; --i) {
            dec += (double)this.num[i];
            dec /= 65536.0;
        }
        return ent + dec;
    }

    public static BigDouble add(BigDouble left, int right) {
        return BigDouble.add(left, new BigDouble(right));
    }

    public static BigDouble add(BigDouble left, BigDouble right) {
        BigDouble bigDouble = new BigDouble();
        bigDouble.intLength = left.intLength > right.intLength ? left.intLength : right.intLength;
        bigDouble.decLength = left.decLength > right.decLength ? left.decLength : right.decLength;
        int carry = 0;
        int iFin = 140 - bigDouble.intLength;
        for (int i = 140 + bigDouble.decLength - 1; i >= iFin; --i) {
            int partial_sum = left.num[i] + right.num[i] + carry;
            carry = partial_sum >= 65536 ? 1 : 0;
            bigDouble.num[i] = partial_sum - carry * 65536;
        }
        if (carry == 1) {
            bigDouble.num[i] = carry;
            ++bigDouble.intLength;
        }
        return bigDouble;
    }

    public static BigDouble Minus(BigDouble left, int right) {
        return BigDouble.Minus(left, new BigDouble(right));
    }

    public static BigDouble Minus(BigDouble left, BigDouble right) {
        if (BigDouble.isBig(right, left)) {
            BigDouble result = BigDouble.Minus(right, left);
            result.positive = false;
            return result;
        }
        BigDouble result = new BigDouble();
        result.decLength = left.decLength > right.decLength ? left.decLength : right.decLength;
        int borrow = 0;
        int fin = 140 - left.intLength;
        for (int i = 140 + result.decLength - 1; i >= fin; --i) {
            int partial_sub = left.num[i] - right.num[i] - borrow;
            result.num[i] = partial_sub < 0 ? partial_sub + 65536 : partial_sub;
            int n = borrow = partial_sub < 0 ? 1 : 0;
            if (partial_sub != 0) {
                if (i >= 140) continue;
                result.intLength = 140 - i;
                continue;
            }
            if (i != 140 + result.decLength - 1 || result.decLength == 0) continue;
            --result.decLength;
        }
        return result;
    }

    public static BigDouble Multy(BigDouble left, int right) {
        return BigDouble.Multy(left, new BigDouble(right));
    }

    public static BigDouble Multy(BigDouble left, BigDouble right) {
        int i;
        BigDouble result = new BigDouble();
        result.positive = left.positive == right.positive;
        result.intLength = left.intLength + right.intLength;
        int finI = 140 - right.intLength;
        int finJ = 140 - left.intLength;
        for (i = 139; i >= finI; --i) {
            for (int j = 139; j >= finJ; --j) {
                int n = i + j - 140 + 1;
                result.num[n] = result.num[n] + left.num[j] * right.num[i];
            }
        }
        finI = 140 - result.intLength;
        for (i = 139; i >= finI; --i) {
            if (result.num[i] <= 65536) continue;
            int n = i - 1;
            result.num[n] = result.num[n] + result.num[i] / 65536;
            int n2 = i;
            result.num[n2] = result.num[n2] % 65536;
        }
        if (result.num[140 - result.intLength] == 0) {
            --result.intLength;
        }
        return result;
    }

    public static BigDouble Divide(BigDouble left, int divisor) throws Exception {
        if (left.intLength == 0) {
            return new BigDouble(0);
        }
        if (divisor > 65536) {
            throw new Exception("Not supported");
        }
        BigDouble dividend = new BigDouble(left);
        BigDouble quotient = new BigDouble();
        quotient.intLength = dividend.intLength;
        int iFin = 140 + dividend.decLength;
        for (int i = 140 - dividend.intLength; i < iFin; ++i) {
            int partial_quotient = dividend.num[i] / divisor;
            int n = i;
            dividend.num[n] = dividend.num[n] - partial_quotient * divisor;
            quotient.num[i] = partial_quotient;
            if (i < 149) {
                int n2 = i + 1;
                dividend.num[n2] = dividend.num[n2] + (dividend.num[i] << 16);
            }
            dividend.num[i] = 0;
        }
        if (quotient.num[140 - dividend.intLength] == 0) {
            --quotient.intLength;
        }
        return quotient;
    }

    public static boolean isBig(BigDouble left, BigDouble right) {
        if (left.intLength > right.intLength) {
            return true;
        }
        if (left.intLength < right.intLength) {
            return false;
        }
        for (int i = 140 - left.intLength; i < 150; ++i) {
            if (left.num[i] == right.num[i]) continue;
            return left.num[i] > right.num[i];
        }
        return false;
    }

    public static boolean isSmall(BigDouble left, BigDouble right) {
        if (left.intLength < right.intLength) {
            return true;
        }
        if (left.intLength > right.intLength) {
            return false;
        }
        for (int i = 140 - left.intLength; i < 150; ++i) {
            if (left.num[i] == right.num[i]) continue;
            return left.num[i] < right.num[i];
        }
        return false;
    }

    public static BigDouble Divide(BigDouble left, BigDouble right) {
        BigDouble dividend = new BigDouble(left);
        BigDouble divisor = new BigDouble(right);
        BigDouble quotient = new BigDouble();
        int divisorLength = divisor.intLength;
        int dividendLength = dividend.intLength;
        int cont = 0;
        for (int i = dividendLength - divisorLength; i >= 0; --i) {
            int ini = 140 - i - dividendLength - cont;
            int fin = 140 - i - 1;
            quotient.num[140 - i - 1] = BigDouble.Substract(dividend, new BigDouble(left, ini, fin));
            BigDouble mul = BigDouble.Multy(divisor, quotient.num[140 - i]);
            for (int j = 0; j < i; ++j) {
                mul = BigDouble.Multy(mul, 65536);
            }
            dividend = BigDouble.Minus(dividend, mul);
            cont = quotient.num[140 - i] == 0 ? 1 : 0;
        }
        return quotient;
    }

    private static int Substract(BigDouble left, BigDouble right) {
        int cont = -1;
        do {
            left = BigDouble.Minus(left, right);
            ++cont;
        } while (left.positive);
        return cont;
    }

    public boolean equals(BigDouble other) {
        return Math.abs(BigDouble.Minus(this, other).ToDouble()) < 1.0E-6;
    }

    @Deprecated
    public int compareTo(Object arg0) {
        return 0;
    }
}

