/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.text;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TextFeatureWeights {
    private final double[] theta;
    private final String[] features;
    private final Map<String, Double> map;

    public TextFeatureWeights(String[] features, double[] theta) {
        if (theta.length != features.length + 1) {
            throw new IllegalArgumentException("Theta length must be same as feature length plus one for the bias weight");
        }
        this.theta = Arrays.copyOf(theta, theta.length);
        this.features = Arrays.copyOf(features, features.length);
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (int i = 0; i < features.length; ++i) {
            map.put(features[i], theta[i + 1]);
        }
        this.map = map;
    }

    public Map<String, Double> getMap() {
        return this.map;
    }

    public List<Map.Entry<String, Double>> getMapByValue() {
        return this.map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).collect(Collectors.toList());
    }
}

