/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.text;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.zomis.machlearn.regression.LogisticRegression;
import net.zomis.machlearn.text.TextFeatureMapper;

public class TextClassification {
    private final UnaryOperator<String> preprocess;
    private final TextFeatureMapper mapper;
    private final double[] theta;
    private final double threshold;

    public TextClassification(UnaryOperator<String> preprocess, TextFeatureMapper mapper, double[] theta, double threshold) {
        this.preprocess = preprocess;
        this.mapper = mapper;
        this.theta = Arrays.copyOf(theta, theta.length);
        this.threshold = threshold;
        int featureCount = mapper.getFeatures().length;
        if (theta.length != featureCount + 1) {
            throw new IllegalArgumentException("Expects theta length (" + theta.length + ") to be " + "equal to feature length (" + featureCount + ") + 1.");
        }
    }

    public double score(String text) {
        double[] features = this.mapper.toFeatures((String)this.preprocess.apply(text));
        return LogisticRegression.hypothesis(this.theta, features);
    }

    public Map<String, Double> getFeatures(String text) {
        String[] features = this.mapper.getFeatures();
        double[] mapFeatures = this.mapper.toFeatures(text);
        int featureCount = features.length;
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < featureCount; ++i) {
            if (mapFeatures[i] == 0.0) continue;
            result.put(features[i], mapFeatures[i] * this.theta[i + 1]);
        }
        return result;
    }

    public String preprocess(String text) {
        return (String)this.preprocess.apply(text);
    }

    public boolean classify(String text) {
        return this.score(text) >= this.threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public TextFeatureMapper getMapper() {
        return this.mapper;
    }
}

