/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.neural;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import net.zomis.machlearn.neural.DummyConnection;
import net.zomis.machlearn.neural.NeuronConnection;
import net.zomis.machlearn.neural.NeuronFunction;
import net.zomis.machlearn.neural.NeuronLayer;
import net.zomis.machlearn.neural.NeuronLink;
import org.apache.commons.math3.analysis.function.Sigmoid;

public class Neuron {
    private static final Sigmoid sigmoid = new Sigmoid();
    public static final NeuronFunction SIGMOID_FUNCTION = x -> {
        double ePowerMinusX = Math.exp(-x);
        return 1.0 / (1.0 + ePowerMinusX);
    };
    private static final DoubleUnaryOperator derivative = x -> {
        double sigmoid = SIGMOID_FUNCTION.calculate(x);
        return sigmoid * (1.0 - sigmoid);
    };
    public final List<NeuronLink> inputs = new ArrayList<NeuronLink>();
    public final List<NeuronConnection> outputs = new ArrayList<NeuronConnection>();
    private final NeuronFunction function = SIGMOID_FUNCTION;
    public double input;
    public double output;
    private final String name;
    final int indexInLayer;

    Neuron(int index, String name) {
        this.inputs.add(new DummyConnection());
        this.indexInLayer = index;
        this.name = name;
    }

    Neuron addInput(Neuron input) {
        NeuronConnection link = NeuronConnection.create(input, this);
        this.inputs.add(link);
        input.outputs.add(link);
        return this;
    }

    public double calculateInput() {
        double sum = 0.0;
        for (NeuronLink link : this.inputs) {
            sum += link.calculateInput();
        }
        return sum;
    }

    public double calculateOutput(double value) {
        return this.function.calculate(value);
    }

    public void addInputs(NeuronLayer layer) {
        for (Neuron neuron : layer) {
            this.addInput(neuron);
        }
    }

    double gPrimInput() {
        return derivative.applyAsDouble(this.input);
    }

    public void printInfo() {
        System.out.printf("Node %s\n inputs %s\n outputs %s\n input %f output %f%n", this, this.inputs, this.outputs, this.input, this.output);
    }

    public String toString() {
        return this.name;
    }

    void process() {
        this.input = this.calculateInput();
        this.output = this.calculateOutput(this.input);
    }

    public List<NeuronLink> getInputs() {
        return this.inputs;
    }

    public double getOutput() {
        return this.output;
    }

    public List<NeuronConnection> getOutputs() {
        return this.outputs;
    }

    public void setOutput(double output) {
        this.output = output;
    }
}

