/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.common;

public class PrecisionRecallF1 {
    private int[][] values = new int[2][2];

    public void add(boolean actual, boolean predicted) {
        int predictedClass = predicted ? 1 : 0;
        int actualClass = actual ? 1 : 0;
        int[] nArray = this.values[predictedClass];
        int n = actualClass;
        nArray[n] = nArray[n] + 1;
    }

    public int get(boolean actual, boolean predicted) {
        int predictedClass = predicted ? 1 : 0;
        int actualClass = actual ? 1 : 0;
        return this.values[predictedClass][actualClass];
    }

    public void falsePositive() {
        this.add(false, true);
    }

    public void falseNegative() {
        this.add(true, false);
    }

    public void truePositive() {
        this.add(true, true);
    }

    public void trueNegative() {
        this.add(false, false);
    }

    public double getPrecision() {
        return (double)this.getTruePositive() / (double)(this.getTruePositive() + this.getFalsePositive());
    }

    public double getRecall() {
        return (double)this.getTruePositive() / (double)(this.getTruePositive() + this.getFalseNegative());
    }

    public int getTruePositive() {
        return this.get(true, true);
    }

    public int getTrueNegative() {
        return this.get(false, false);
    }

    public int getFalsePositive() {
        return this.get(false, true);
    }

    public int getFalseNegative() {
        return this.get(true, false);
    }

    public double getF1Score() {
        double precision = this.getPrecision();
        double recall = this.getRecall();
        return 2.0 * precision * recall / (precision + recall);
    }

    public String toString() {
        return String.format("truePositive: %d, falsePositive: %d, trueNegative: %d, falseNegative: %d, precision %f, recall %f, f1 score: %f", this.getTruePositive(), this.getFalsePositive(), this.getTrueNegative(), this.getFalseNegative(), this.getPrecision(), this.getRecall(), this.getF1Score());
    }
}

