/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.gameai;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.zomis.gameai.Feature;
import net.zomis.gameai.FeatureExtractor;

public class FeatureExtractors<T> {
    private final List<FeatureExtractor<T>> extractors = new ArrayList<FeatureExtractor<T>>();
    private final Class<T> clazz;

    public FeatureExtractors(Class<T> clazz) {
        this.clazz = clazz;
    }

    public List<Feature<?>> extract(T object) {
        return this.extractors.stream().map(ex -> ex.extract(object)).collect(Collectors.toList());
    }

    public void add(FeatureExtractor<T> extractor) {
        this.extractors.add(extractor);
    }
}

