/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.images;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.zomis.machlearn.images.ImageAnalysis;
import net.zomis.machlearn.images.ImageNetwork;
import net.zomis.machlearn.images.SlidingWindowResult;
import net.zomis.machlearn.images.ZPoint;
import org.imgscalr.Scalr;

public class SlidingWindow {
    private final ImageNetwork network;
    private final BufferedImage image;
    private final ImageAnalysis analysis;
    private int minScaleX;
    private int maxScaleX;
    private int step;
    private boolean overlapping;

    public SlidingWindow(ImageAnalysis analysis, ImageNetwork network, BufferedImage image) {
        if (analysis.getWidth() != analysis.getHeight()) {
            throw new IllegalArgumentException("Different width and height is not yet supported");
        }
        this.analysis = analysis;
        this.network = network;
        this.image = image;
    }

    public SlidingWindow scaleX(int min, int max) {
        this.minScaleX = min;
        this.maxScaleX = max;
        return this;
    }

    public SlidingWindow step(int stepSize) {
        this.step = stepSize;
        return this;
    }

    public SlidingWindowResult run() {
        HashMap<ZPoint, Set<Object>> foundObjects = new HashMap<ZPoint, Set<Object>>();
        for (int size = this.minScaleX; size < this.maxScaleX; size += 2) {
            this.runWithSize(size, foundObjects);
        }
        return new SlidingWindowResult(foundObjects);
    }

    private void runWithSize(int size, Map<ZPoint, Set<Object>> foundObjects) {
        System.out.println("Running with size " + size + " found so far " + foundObjects.size());
        int bottom = this.image.getHeight() - size;
        int right = this.image.getWidth() - size;
        for (int y = 0; y < bottom + this.step; y += this.step) {
            if (y > bottom) {
                y = bottom;
            }
            System.out.println("Running y " + y + " found so far " + foundObjects);
            for (int x = 0; x < right + this.step; ++x) {
                Set<Object> results;
                if (x > right) {
                    x = right;
                }
                if (!this.overlapping) {
                    int xv = x;
                    int yv = y;
                    boolean overlaps = foundObjects.keySet().stream().anyMatch(point -> point.isInside(xv, yv, xv + size, yv + size));
                    if (overlaps) continue;
                }
                if ((results = this.runAt(this.image, size, size, x, y)) != null) {
                    foundObjects.put(new ZPoint(x, y), results);
                }
                if (x == right) break;
            }
            if (y == bottom) break;
        }
    }

    private Set<Object> runAt(BufferedImage image, int sizeX, int sizeY, int x, int y) {
        double[] input = this.convertImageToInput(image, sizeX, sizeY, x, y);
        double[] networkResults = this.network.getNetwork().run(input);
        HashSet<Object> results = null;
        for (int i = 0; i < networkResults.length; ++i) {
            if (!(networkResults[i] >= 0.75)) continue;
            if (results == null) {
                results = new HashSet<Object>();
            }
            results.add(this.network.getObject(i));
        }
        if (results != null) {
            System.out.printf("Found %s at %d, %d with values %s%n", results, x, y, Arrays.toString(networkResults));
        }
        return results;
    }

    private double[] convertImageToInput(BufferedImage image, int sizeX, int sizeY, int x, int y) {
        BufferedImage cropped = Scalr.crop((BufferedImage)image, (int)x, (int)y, (int)sizeX, (int)sizeY, (BufferedImageOp[])new BufferedImageOp[0]);
        BufferedImage input = Scalr.resize((BufferedImage)cropped, (int)this.analysis.getWidth(), (int)this.analysis.getHeight(), (BufferedImageOp[])new BufferedImageOp[0]);
        return ImageAnalysis.imagePart(input, 0, 0, this.analysis.getWidth(), this.analysis.getHeight(), true);
    }

    public SlidingWindow overlapping(boolean b) {
        this.overlapping = b;
        return this;
    }
}

