/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.text;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.zomis.machlearn.text.TextFeatureMapper;

public class TextFeatureBuilder {
    public static final Comparator<Map.Entry<String, Integer>> SORT_BY_VALUE = Comparator.comparing(Map.Entry::getValue).reversed();
    private final int[] nGrams;
    private final Map<String, Integer> counts;
    private final BiPredicate<String, Integer> featureFilter;

    public TextFeatureBuilder(int[] nGrams, BiPredicate<String, Integer> featureFilter) {
        if (nGrams != null && nGrams.length < 0) {
            throw new IllegalArgumentException("nGrams must have at least one value");
        }
        this.nGrams = nGrams;
        this.counts = new HashMap<String, Integer>();
        this.featureFilter = featureFilter;
    }

    public void add(String processed) {
        List<String> sections = Arrays.asList(processed.split(" "));
        sections = sections.stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        for (int n : this.nGrams) {
            for (int i = 0; i <= sections.size() - n; ++i) {
                List<String> values = sections.subList(i, i + n);
                String value = String.join((CharSequence)" ", values).trim();
                if (value.isEmpty() || !this.featureFilter.test(value, n)) continue;
                this.counts.merge(value, 1, Integer::sum);
            }
        }
    }

    public TextFeatureMapper mapper(int maxLimit) {
        String[] features = this.counts.entrySet().stream().sorted(SORT_BY_VALUE).limit(maxLimit).map(Map.Entry::getKey).collect(Collectors.toList()).toArray(new String[maxLimit]);
        return new TextFeatureMapper(features);
    }

    public Map<String, Integer> getCounts() {
        return new HashMap<String, Integer>(this.counts);
    }
}

