/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.images;

import java.awt.image.BufferedImage;
import net.zomis.machlearn.images.ImageNetwork;
import net.zomis.machlearn.images.ImageNetworkBuilder;
import net.zomis.machlearn.images.SlidingWindow;

public class ImageAnalysis {
    private final int width;
    private final int height;
    private final boolean useGrayscale;

    public ImageAnalysis(int width, int height, boolean useGrayscale) {
        this.width = width;
        this.height = height;
        this.useGrayscale = useGrayscale;
    }

    public ImageNetworkBuilder neuralNetwork(int ... hiddenLayerSizes) {
        return new ImageNetworkBuilder(this, this.width * this.height * this.partsPerPixel(), hiddenLayerSizes);
    }

    public double[] imagePart(BufferedImage image, int x, int y) {
        return ImageAnalysis.imagePart(image, x, y, this.width, this.height, this.useGrayscale);
    }

    public static double[] imagePart(BufferedImage image, int x, int y, int width, int height, boolean useGrayscale) {
        int partsPerPixel = useGrayscale ? 1 : 3;
        double[] result = new double[width * height * partsPerPixel];
        int i = 0;
        for (int yy = y; yy < y + height; ++yy) {
            for (int xx = x; xx < x + width; ++xx) {
                double[] rgbGray = ImageAnalysis.getRGB(image, xx, yy);
                if (useGrayscale) {
                    result[i++] = rgbGray[4];
                    continue;
                }
                result[i++] = rgbGray[1];
                result[i++] = rgbGray[2];
                result[i++] = rgbGray[3];
            }
        }
        return result;
    }

    private int partsPerPixel() {
        return this.useGrayscale ? 1 : 3;
    }

    public SlidingWindow slidingWindow(ImageNetwork network, BufferedImage image) {
        return new SlidingWindow(this, network, image);
    }

    public static double[] getRGB(BufferedImage image, int x, int y) {
        if (x < 0) {
            x = image.getWidth() + x;
        }
        if (y < 0) {
            y = image.getHeight() + y;
        }
        int rgb = image.getRGB(x, y);
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        double gray = 0.2989 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
        return new double[]{(double)a / 255.0, (double)r / 255.0, (double)g / 255.0, (double)b / 255.0, gray / 255.0};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isGrayscale() {
        return this.useGrayscale;
    }
}

