/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.gameai.features;

import java.util.function.ToIntFunction;
import net.zomis.gameai.Feature;
import net.zomis.gameai.FeatureExtractor;
import net.zomis.gameai.FeatureFunction;

public class IntegerFeature<E>
implements FeatureExtractor<E> {
    private final ToIntFunction<E> valueRetriever;
    private final int bits;
    private final boolean includeFull;
    private final String name;

    public IntegerFeature(String name, ToIntFunction<E> function, int bits, boolean includeFull) {
        this.name = name;
        this.valueRetriever = function;
        this.bits = bits;
        this.includeFull = includeFull;
    }

    @Override
    public Feature<?> extract(E object) {
        int value = this.valueRetriever.applyAsInt(object);
        FeatureFunction<Integer> ff = (index, data) -> {
            if (this.includeFull && index == 0) {
                return data.intValue();
            }
            int minus = this.includeFull ? 1 : 0;
            int shiftLeft = index - minus;
            int shiftedLeft = 1 << shiftLeft;
            int v = data & shiftedLeft;
            return v >> shiftLeft;
        };
        return new Feature<Integer>(this.bits, this.name, value, ff);
    }
}

