/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.machlearn.images;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.zomis.machlearn.images.ImageAnalysis;
import net.zomis.machlearn.neural.NeuralNetwork;

public class ImageNetwork {
    private final NeuralNetwork network;
    private final Object[] outputs;
    private final ImageAnalysis analysis;

    public ImageNetwork(ImageAnalysis analysis, NeuralNetwork network, Object[] outputs) {
        if (network.getOutputLayer().size() != outputs.length) {
            throw new IllegalArgumentException(String.format("Network output layer (%d) does not match object array length (%d)", network.getOutputLayer().size(), outputs.length));
        }
        this.analysis = analysis;
        this.network = network;
        this.outputs = Arrays.copyOf(outputs, outputs.length);
    }

    public Object[] getOutputs() {
        return Arrays.copyOf(this.outputs, this.outputs.length);
    }

    public Map<Object, Double> run(double[] imageData) {
        double[] outputs = this.network.run(imageData);
        HashMap<Object, Double> result = new HashMap<Object, Double>();
        for (int i = 0; i < outputs.length; ++i) {
            result.put(this.outputs[i], outputs[i]);
        }
        return result;
    }

    public NeuralNetwork getNetwork() {
        return this.network;
    }

    public Object getObject(int index) {
        return this.outputs[index];
    }

    public int getWidth() {
        return this.analysis.getWidth();
    }

    public int getHeight() {
        return this.analysis.getHeight();
    }

    public double[] imagePart(BufferedImage image, int x, int y) {
        return this.analysis.imagePart(image, x, y);
    }

    public ImageAnalysis getAnalysis() {
        return this.analysis;
    }

    public ImageNetwork flip() {
        ImageAnalysis flipped = new ImageAnalysis(this.getHeight(), this.getWidth(), this.getAnalysis().isGrayscale());
        return new ImageNetwork(flipped, this.network, this.getOutputs());
    }
}

