/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.ext;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.zomis.fight.ext.RatingElo;
import net.zomis.fight.ext.WinResult;

public class RatingContext<P> {
    private final Function<P, Double> startings;
    private final RatingElo elo;
    private final Map<P, Double> ratings = new HashMap<P, Double>();

    public RatingContext(Function<P, Double> startingRatings) {
        this.startings = startingRatings;
        this.elo = new RatingElo();
    }

    public void addFight(P player1, P player2, WinResult result) {
        double original1 = this.ratings.computeIfAbsent(player1, this.startings);
        double original2 = this.ratings.computeIfAbsent(player2, this.startings);
        double change1 = this.elo.calculateRatingChange((double)this.ratings.get(player1), (double)this.ratings.get(player2), result);
        double change2 = this.elo.calculateRatingChange((double)this.ratings.get(player2), (double)this.ratings.get(player1), result.reversed());
        System.out.println(String.format("%s (%f) vs. %s (%f): %s. Changes: %f, %f", new Object[]{player1, original1, player2, original2, result, change1, change2}));
        this.ratings.put(player1, original1 + change1);
        this.ratings.put(player2, original2 + change2);
    }

    public void setRating(P player, double rating) {
        Objects.requireNonNull(player);
        this.ratings.put(player, rating);
    }

    public void clearRating(P player) {
        Objects.requireNonNull(player);
        this.ratings.remove(player);
    }

    public <A> Map<P, Double> calculateRatings(Stream<A> fightStream, Function<A, P> who1, Function<A, P> who2, Function<A, WinResult> ratingCalc) {
        ((Stream)fightStream.sequential()).forEach(fight -> this.addFight(who1.apply(fight), who2.apply(fight), (WinResult)((Object)((Object)ratingCalc.apply(fight)))));
        return new HashMap<P, Double>(this.ratings);
    }
}

