/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.v2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.zomis.fight.v2.IndexResults;
import net.zomis.fight.v2.StatsDataExtract;
import net.zomis.fight.v2.StatsInterface;
import net.zomis.fight.v2.StatsPerform;
import net.zomis.fight.v2.StatsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsExtract<Q>
implements StatsInterface,
StatsStore {
    private static final Logger logger = LoggerFactory.getLogger(StatsExtract.class);
    private final Map<String, Map<Object, List<Object>>> values = new HashMap<String, Map<Object, List<Object>>>();
    private final Map<String, Function> knownIndexes = new HashMap<String, Function>();
    private final Map<String, List<StatsDataExtract<Q, Object, Object>>> extractorsTuple = new HashMap<String, List<StatsDataExtract<Q, Object, Object>>>();
    private Q current;
    private final Map<String, Collector<Object, ?, ?>> collectors = new HashMap();
    private final Map<String, Collector<Object, ?, ?>> postCollectors = new HashMap();
    private IndexResults results = new IndexResults(0);
    private String[] indexes;

    public <T, R> StatsExtract<Q> valueAndThen(String name, Class<T> valueType, Collector<T, ?, R> collector, Collector<R, ?, ?> resultCollector) {
        if (this.collectors.containsKey(name)) {
            throw new IllegalStateException("Collector for '" + name + "' already exists");
        }
        this.collectors.put(name, collector);
        this.postCollectors.put(name, resultCollector);
        return this;
    }

    public <T> StatsExtract<Q> value(String name, Class<T> valueType, Collector<T, ?, ?> collector) {
        if (this.collectors.containsKey(name)) {
            throw new IllegalStateException("Collector for '" + name + "' already exists");
        }
        this.collectors.put(name, collector);
        return this;
    }

    public <T, U> StatsExtract<Q> dataTuple(String tag, Class<T> tClass, Class<U> uClass, StatsDataExtract<Q, T, U> extract) {
        this.extractorsTuple.putIfAbsent(tag, new ArrayList());
        this.extractorsTuple.get(tag).add(extract);
        return this;
    }

    public StatsExtract<Q> indexes(String ... indexes) {
        this.indexes = Arrays.copyOf(indexes, indexes.length);
        return this;
    }

    public <T> StatsExtract<Q> data(String tag, Class<T> tClass, StatsDataExtract<Q, T, Object> extract) {
        this.extractorsTuple.putIfAbsent(tag, new ArrayList());
        this.extractorsTuple.get(tag).add(extract);
        return this;
    }

    @Override
    public <T, U> void postTuple(String tag, T primary, U secondary) {
        logger.debug("Post tuple '{}' primary: {} secondary: {}", new Object[]{tag, primary, secondary});
        this.extractorsTuple.getOrDefault(tag, Collections.emptyList()).forEach(s -> s.extract(this, primary, secondary));
    }

    @Override
    public <T> void post(String tag, T data) {
        logger.debug("Post {} data {}", (Object)tag, data);
        this.extractorsTuple.getOrDefault(tag, Collections.emptyList()).forEach(s -> s.extract(this, data, null));
    }

    private void finishCurrent() {
        if (this.knownIndexes.size() != this.indexes.length) {
            List wantedButNotKnown = Arrays.stream(this.indexes).filter(indexName -> !this.knownIndexes.containsKey(indexName)).collect(Collectors.toList());
            throw new IllegalStateException(String.format("Unexpected indexes. Expected %s but found %s. Missing %s", Arrays.toString(this.indexes), this.knownIndexes.keySet(), wantedButNotKnown));
        }
        for (Map.Entry<String, Map<Object, List<Object>>> valueSet : this.values.entrySet()) {
            String valueName = valueSet.getKey();
            Map<Object, List<Object>> groupedValues = valueSet.getValue();
            for (Map.Entry<Object, List<Object>> groupedValue : groupedValues.entrySet()) {
                Object key = groupedValue.getKey();
                List<Object> objects = groupedValue.getValue();
                List<Object> currentIndexes = this.getIndexesFor(this.knownIndexes, key);
                Collector<Object, ?, ?> collector = this.collectors.get(valueName);
                Collector<Object, ?, ?> postCollector = this.postCollectors.get(valueName);
                if (postCollector != null) {
                    Object resultA = objects.stream().collect(collector);
                    this.results.addRecursive(valueName, postCollector, currentIndexes, Collections.singletonList(resultA));
                } else {
                    this.results.addRecursive(valueName, collector, currentIndexes, objects);
                }
                objects.clear();
            }
        }
    }

    private List<Object> getIndexesFor(Map<String, Function> knownIndexes, Object key) {
        return Arrays.stream(this.indexes).map(knownIndexes::get).map(fnc -> fnc.apply(key)).collect(Collectors.toList());
    }

    public void index(String name, Function savedKeyToIndex) {
        this.knownIndexes.put(name, savedKeyToIndex);
    }

    public static <Q> StatsExtract<Q> create() {
        return new StatsExtract<Q>();
    }

    public IndexResults getResults() {
        return this.results;
    }

    @Override
    public void save(String name, Object key, Object value) {
        this.values.computeIfAbsent(name, s -> new HashMap());
        this.values.get(name).computeIfAbsent(key, s -> new ArrayList());
        this.values.get(name).get(key).add(value);
    }

    public void perform(StatsPerform<Q> perform, Q data, int count) {
        this.current = data;
        perform.perform(this, data, count);
        this.finishCurrent();
    }

    @Override
    public Q getCurrent() {
        return this.current;
    }

    public Object get(String key) {
        throw new UnsupportedOperationException("Not implemented yet. Meant as a hashmap to store things between posts");
    }

    public void set(String key, Object value) {
        throw new UnsupportedOperationException("Not implemented yet. Meant as a hashmap to store things between posts");
    }

    public IndexResults finishResults() {
        this.results.finish();
        return this.results;
    }
}

